// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DataPushService.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl._event {
  public class DataPushService : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("event.DataPushService:1.0.0", null);

    public DataPushService(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public DataPushService(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new DataPushService StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new DataPushService(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum EntryType {
      SENSORLIST,
      SENSORLOG,
      AMSLIST,
      AMSLOG,
      AUDITLOG,
    }

    public const int ERR_NO_SUCH_ID = 1;

    public const int ERR_INVALID_PARAMS = 2;

    public const int ERR_MAX_ENTRIES_REACHED = 3;

    public class EntrySettings : ICloneable {
      public object Clone() {
        EntrySettings copy = new EntrySettings();
        copy.url = this.url;
        copy.allowOffTimeRangeCerts = this.allowOffTimeRangeCerts;
        copy.caCertChain = this.caCertChain;
        copy.useAuth = this.useAuth;
        copy.username = this.username;
        copy.password = this.password;
        copy.type = this.type;
        copy.items = this.items;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["url"] = this.url;
        json["allowOffTimeRangeCerts"] = this.allowOffTimeRangeCerts;
        json["caCertChain"] = this.caCertChain;
        json["useAuth"] = this.useAuth;
        json["username"] = this.username;
        json["password"] = this.password;
        json["type"] = (int)this.type;
        json["items"] = new JsonArray(this.items.Select(
          _value => (JsonValue)(_value)));
        return json;
      }

      public static EntrySettings Decode(LightJson.JsonObject json, Agent agent) {
        EntrySettings inst = new EntrySettings();
        inst.url = (string)json["url"];
        inst.allowOffTimeRangeCerts = (bool)json["allowOffTimeRangeCerts"];
        inst.caCertChain = (string)json["caCertChain"];
        inst.useAuth = (bool)json["useAuth"];
        inst.username = (string)json["username"];
        inst.password = (string)json["password"];
        inst.type = (Com.Raritan.Idl._event.DataPushService.EntryType)(int)json["type"];
        inst.items = new System.Collections.Generic.List<string>(json["items"].AsJsonArray.Select(
          _value => (string)_value));
        return inst;
      }

      public string url = "";
      public bool allowOffTimeRangeCerts = false;
      public string caCertChain = "";
      public bool useAuth = false;
      public string username = "";
      public string password = "";
      public Com.Raritan.Idl._event.DataPushService.EntryType type = Com.Raritan.Idl._event.DataPushService.EntryType.SENSORLIST;
      public System.Collections.Generic.IEnumerable<string> items = new System.Collections.Generic.List<string>();
    }

    public class AddEntryResult {
      public int _ret_;
      public int entryId;
    }

    public AddEntryResult addEntry(Com.Raritan.Idl._event.DataPushService.EntrySettings entrySettings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entrySettings"] = entrySettings.Encode();

      var _result = RpcCall("addEntry", _parameters);
      var _ret = new AddEntryResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.entryId = (int)_result["entryId"];
      return _ret;
    }

    public AsyncRequest addEntry(Com.Raritan.Idl._event.DataPushService.EntrySettings entrySettings, AsyncRpcResponse<AddEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addEntry(entrySettings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addEntry(Com.Raritan.Idl._event.DataPushService.EntrySettings entrySettings, AsyncRpcResponse<AddEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entrySettings"] = entrySettings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addEntry", _parameters,
        _result => {
          try {
            var _ret = new AddEntryResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.entryId = (int)_result["entryId"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ModifyEntryResult {
      public int _ret_;
    }

    public ModifyEntryResult modifyEntry(int entryId, Com.Raritan.Idl._event.DataPushService.EntrySettings entrySettings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entryId"] = entryId;
      _parameters["entrySettings"] = entrySettings.Encode();

      var _result = RpcCall("modifyEntry", _parameters);
      var _ret = new ModifyEntryResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest modifyEntry(int entryId, Com.Raritan.Idl._event.DataPushService.EntrySettings entrySettings, AsyncRpcResponse<ModifyEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return modifyEntry(entryId, entrySettings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest modifyEntry(int entryId, Com.Raritan.Idl._event.DataPushService.EntrySettings entrySettings, AsyncRpcResponse<ModifyEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entryId"] = entryId;
        _parameters["entrySettings"] = entrySettings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("modifyEntry", _parameters,
        _result => {
          try {
            var _ret = new ModifyEntryResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteEntryResult {
      public int _ret_;
    }

    public DeleteEntryResult deleteEntry(int entryId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entryId"] = entryId;

      var _result = RpcCall("deleteEntry", _parameters);
      var _ret = new DeleteEntryResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteEntry(int entryId, AsyncRpcResponse<DeleteEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteEntry(entryId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteEntry(int entryId, AsyncRpcResponse<DeleteEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entryId"] = entryId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteEntry", _parameters,
        _result => {
          try {
            var _ret = new DeleteEntryResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetEntryResult {
      public int _ret_;
      public Com.Raritan.Idl._event.DataPushService.EntrySettings entrySettings;
    }

    public GetEntryResult getEntry(int entryId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entryId"] = entryId;

      var _result = RpcCall("getEntry", _parameters);
      var _ret = new GetEntryResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.entrySettings = Com.Raritan.Idl._event.DataPushService.EntrySettings.Decode(_result["entrySettings"], agent);
      return _ret;
    }

    public AsyncRequest getEntry(int entryId, AsyncRpcResponse<GetEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getEntry(entryId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getEntry(int entryId, AsyncRpcResponse<GetEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entryId"] = entryId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getEntry", _parameters,
        _result => {
          try {
            var _ret = new GetEntryResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.entrySettings = Com.Raritan.Idl._event.DataPushService.EntrySettings.Decode(_result["entrySettings"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ListEntriesResult {
      public System.Collections.Generic.IDictionary<int, Com.Raritan.Idl._event.DataPushService.EntrySettings> _ret_;
    }

    public ListEntriesResult listEntries() {
      JsonObject _parameters = null;
      var _result = RpcCall("listEntries", _parameters);
      var _ret = new ListEntriesResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl._event.DataPushService.EntrySettings>(_value["key"], Com.Raritan.Idl._event.DataPushService.EntrySettings.Decode(_value["value"], agent))));
      return _ret;
    }

    public AsyncRequest listEntries(AsyncRpcResponse<ListEntriesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listEntries(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listEntries(AsyncRpcResponse<ListEntriesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("listEntries", _parameters,
        _result => {
          try {
            var _ret = new ListEntriesResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl._event.DataPushService.EntrySettings>(_value["key"], Com.Raritan.Idl._event.DataPushService.EntrySettings.Decode(_value["value"], agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class PushDataResult {
      public int _ret_;
    }

    public PushDataResult pushData(int entryId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entryId"] = entryId;

      var _result = RpcCall("pushData", _parameters);
      var _ret = new PushDataResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest pushData(int entryId, AsyncRpcResponse<PushDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return pushData(entryId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest pushData(int entryId, AsyncRpcResponse<PushDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entryId"] = entryId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("pushData", _parameters,
        _result => {
          try {
            var _ret = new PushDataResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
