// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DsamPort.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.dsam {
  public class DsamPort : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("dsam.DsamPort:1.0.0", null);

    public DsamPort(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public DsamPort(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new DsamPort StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new DsamPort(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int SUCCESS = 0;

    public const int SETTINGS_INVALID = 1;

    public const int SSH_DPA_PORT_INVALID = 2;

    public const int SSH_DPA_PORT_IN_USE = 3;

    public enum DeviceInterfaceType {
      DEV_IFTYPE_AUTO,
      DEV_IFTYPE_DTE,
      DEV_IFTYPE_DCE,
    }

    public enum Parity {
      PARITY_NONE,
      PARITY_ODD,
      PARITY_EVEN,
    }

    public enum FlowControl {
      FLOW_CTRL_NONE,
      FLOW_CTRL_HARDWARE,
      FLOW_CTRL_SOFTWARE,
    }

    public enum State {
      STATE_AVAILABLE,
      STATE_OCCUPIED,
      STATE_BUSY,
    }

    public class Info : ICloneable {
      public object Clone() {
        Info copy = new Info();
        copy.dsamNumber = this.dsamNumber;
        copy.portNumber = this.portNumber;
        copy.connected = this.connected;
        copy.devIfType = this.devIfType;
        copy.state = this.state;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["dsamNumber"] = this.dsamNumber;
        json["portNumber"] = this.portNumber;
        json["connected"] = this.connected;
        json["devIfType"] = (int)this.devIfType;
        json["state"] = (int)this.state;
        return json;
      }

      public static Info Decode(LightJson.JsonObject json, Agent agent) {
        Info inst = new Info();
        inst.dsamNumber = (int)json["dsamNumber"];
        inst.portNumber = (int)json["portNumber"];
        inst.connected = (bool)json["connected"];
        inst.devIfType = (Com.Raritan.Idl.dsam.DsamPort.DeviceInterfaceType)(int)json["devIfType"];
        inst.state = (Com.Raritan.Idl.dsam.DsamPort.State)(int)json["state"];
        return inst;
      }

      public int dsamNumber = 0;
      public int portNumber = 0;
      public bool connected = false;
      public Com.Raritan.Idl.dsam.DsamPort.DeviceInterfaceType devIfType = Com.Raritan.Idl.dsam.DsamPort.DeviceInterfaceType.DEV_IFTYPE_AUTO;
      public Com.Raritan.Idl.dsam.DsamPort.State state = Com.Raritan.Idl.dsam.DsamPort.State.STATE_AVAILABLE;
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.name = this.name;
        copy.devIfType = this.devIfType;
        copy.baudRate = this.baudRate;
        copy.parity = this.parity;
        copy.stopBits = this.stopBits;
        copy.flowCtrl = this.flowCtrl;
        copy.breakDurationMs = this.breakDurationMs;
        copy.sshDpaPortEnabled = this.sshDpaPortEnabled;
        copy.sshDpaPort = this.sshDpaPort;
        copy.allowSharedAccess = this.allowSharedAccess;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["devIfType"] = (int)this.devIfType;
        json["baudRate"] = this.baudRate;
        json["parity"] = (int)this.parity;
        json["stopBits"] = this.stopBits;
        json["flowCtrl"] = (int)this.flowCtrl;
        json["breakDurationMs"] = this.breakDurationMs;
        json["sshDpaPortEnabled"] = this.sshDpaPortEnabled;
        json["sshDpaPort"] = this.sshDpaPort;
        json["allowSharedAccess"] = this.allowSharedAccess;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.name = (string)json["name"];
        inst.devIfType = (Com.Raritan.Idl.dsam.DsamPort.DeviceInterfaceType)(int)json["devIfType"];
        inst.baudRate = (int)json["baudRate"];
        inst.parity = (Com.Raritan.Idl.dsam.DsamPort.Parity)(int)json["parity"];
        inst.stopBits = (int)json["stopBits"];
        inst.flowCtrl = (Com.Raritan.Idl.dsam.DsamPort.FlowControl)(int)json["flowCtrl"];
        inst.breakDurationMs = (int)json["breakDurationMs"];
        inst.sshDpaPortEnabled = (bool)json["sshDpaPortEnabled"];
        inst.sshDpaPort = (int)json["sshDpaPort"];
        inst.allowSharedAccess = (bool)json["allowSharedAccess"];
        return inst;
      }

      public string name = "";
      public Com.Raritan.Idl.dsam.DsamPort.DeviceInterfaceType devIfType = Com.Raritan.Idl.dsam.DsamPort.DeviceInterfaceType.DEV_IFTYPE_AUTO;
      public int baudRate = 0;
      public Com.Raritan.Idl.dsam.DsamPort.Parity parity = Com.Raritan.Idl.dsam.DsamPort.Parity.PARITY_NONE;
      public int stopBits = 0;
      public Com.Raritan.Idl.dsam.DsamPort.FlowControl flowCtrl = Com.Raritan.Idl.dsam.DsamPort.FlowControl.FLOW_CTRL_NONE;
      public int breakDurationMs = 0;
      public bool sshDpaPortEnabled = false;
      public int sshDpaPort = 0;
      public bool allowSharedAccess = false;
    }

    public class InfoChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("dsam.DsamPort.InfoChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.dsam.DsamPort.Info oldInfo = new Com.Raritan.Idl.dsam.DsamPort.Info();
      public Com.Raritan.Idl.dsam.DsamPort.Info newInfo = new Com.Raritan.Idl.dsam.DsamPort.Info();
      public string portName = "";
    }

    public class SettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("dsam.DsamPort.SettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int dsamNumber = 0;
      public int portNumber = 0;
      public Com.Raritan.Idl.dsam.DsamPort.Settings oldSettings = new Com.Raritan.Idl.dsam.DsamPort.Settings();
      public Com.Raritan.Idl.dsam.DsamPort.Settings newSettings = new Com.Raritan.Idl.dsam.DsamPort.Settings();
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.dsam.DsamPort.Info _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.dsam.DsamPort.Info.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.dsam.DsamPort.Info.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.dsam.DsamPort.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.dsam.DsamPort.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.dsam.DsamPort.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.dsam.DsamPort.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.dsam.DsamPort.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.dsam.DsamPort.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetTtyUsbNumberResult {
      public int _ret_;
    }

    public GetTtyUsbNumberResult getTtyUsbNumber() {
      JsonObject _parameters = null;
      var _result = RpcCall("getTtyUsbNumber", _parameters);
      var _ret = new GetTtyUsbNumberResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getTtyUsbNumber(AsyncRpcResponse<GetTtyUsbNumberResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTtyUsbNumber(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTtyUsbNumber(AsyncRpcResponse<GetTtyUsbNumberResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getTtyUsbNumber", _parameters,
        _result => {
          try {
            var _ret = new GetTtyUsbNumberResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetStateResult {
    }

    public SetStateResult setState(Com.Raritan.Idl.dsam.DsamPort.State state) {
      var _parameters = new LightJson.JsonObject();
      _parameters["state"] = (int)state;

      var _result = RpcCall("setState", _parameters);
      var _ret = new SetStateResult();
      return _ret;
    }

    public AsyncRequest setState(Com.Raritan.Idl.dsam.DsamPort.State state, AsyncRpcResponse<SetStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setState(state, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setState(Com.Raritan.Idl.dsam.DsamPort.State state, AsyncRpcResponse<SetStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["state"] = (int)state;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setState", _parameters,
        _result => {
          try {
            var _ret = new SetStateResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
