# this file has been automatically generated by valabind
from ctypes import *
from ctypes.util import find_library
lib = CDLL (find_library ('r_asm'))
def rlist2array(x,y):
	it = x.iterator ()
	ret = []
	while True:
		data = it.get_data ()
		ds = cast (data, POINTER(y)).contents
		ret.append (ds)
		if it.n == None:
			break
		it = it.get_next ()
	return ret

class AddressHolder(object):
	def __get__(self, obj, type_):
		if getattr(obj, '_address', None) is None:
			obj._address = addressof(obj)
		return obj._address

	def __set__(self, obj, value):
		obj._address = value

class WrappedRMethod(object):
	def __init__(self, cname, args, ret):
		self.cname = cname
		self.args = args
		self.ret = ret
		self.args_set = False
		self.method = getattr(lib, cname)

	def __call__(self, *a):
		if not self.args_set:
			if self.args:
				self.method.argtypes = [eval(x.strip()) for x in self.args.split(',')]
			self.method.restype = eval(self.ret) if self.ret else None
			self.args_set = True
		return self.method(*a)

class WrappedApiMethod(object):
	def __init__(self, method, ret2, last):
		self.method = method
		self._o = None
		self.ret2 = ret2
		self.last = last

	def __call__(self, *a):
		result = self.method(self._o, *a)
		if self.ret2:
			result = eval(self.ret2)(result)
		if self.last:
			return getattr(result, self.last)
		return result

	def __get__(self, obj, type_):
		self._o = obj._o
		return self

def register(cname, args, ret):
	ret2 = last = None
	if ret:
		if ret[0]>='A' and ret[0]<='Z':
			x = ret.find('<')
			if x != -1:
				ret = ret[0:x]
			last = 'contents'
			ret = 'POINTER('+ret+')'
		else:
			last = 'value'
			ret2 = ret
			
	method = WrappedRMethod(cname, args, ret)
	wrapped_method = WrappedApiMethod(method, ret2, last)
	return wrapped_method, method

class RAsm(Structure): #0
	_fields_ = [
		("bits", c_int),
		("big_endian", c_bool),
		("syntax", c_int),
		("pc", c_ulonglong),
		("plugins", c_void_p),
	]
	def __init__(self):
		Structure.__init__(self)
		r_asm_new = lib.r_asm_new
		r_asm_new.restype = c_void_p
		self._o = r_asm_new ()

	_o = AddressHolder()

	use, r_asm_use = register('r_asm_use','c_void_p, c_char_p','c_bool')
	set_bits, r_asm_set_bits = register('r_asm_set_bits','c_void_p, c_int','c_bool')
	set_syntax, r_asm_set_syntax = register('r_asm_set_syntax','c_void_p, c_long','c_bool')
	set_pc, r_asm_set_pc = register('r_asm_set_pc','c_void_p, c_ulonglong','c_bool')
	set_big_endian, r_asm_set_big_endian = register('r_asm_set_big_endian','c_void_p, c_bool','c_bool')
	disassemble, r_asm_disassemble = register('r_asm_disassemble','c_void_p, POINTER(RAsmOp), POINTER(c_ubyte), c_int','c_int')
	assemble, r_asm_assemble = register('r_asm_assemble','c_void_p, POINTER(RAsmOp), c_char_p','c_int')
	mdisassemble, r_asm_mdisassemble = register('r_asm_mdisassemble','c_void_p, POINTER(c_ubyte), c_int','RAsmCode')
	mdisassemble_hexstr, r_asm_mdisassemble_hexstr = register('r_asm_mdisassemble_hexstr','c_void_p, c_char_p','RAsmCode')
	massemble, r_asm_massemble = register('r_asm_massemble','c_void_p, c_char_p','RAsmCode')
	assemble_file, r_asm_assemble_file = register('r_asm_assemble_file','c_void_p, c_char_p','RAsmCode')
	filter_input, r_asm_filter_input = register('r_asm_filter_input','c_void_p, c_char_p','c_bool')
	filter_output, r_asm_filter_output = register('r_asm_filter_output','c_void_p, c_char_p','c_bool')
	free, r_asm_free = register('r_asm_free','c_void_p',None)

class RAsmOp(Structure): #1
	_fields_ = [
		("inst_len", c_int),
		("payload", c_int),
		('buf', c_ubyte * 1024),
		('buf_asm', c_char * 1024),
		('buf_hex', c_char * 1024),
		('buf_err', c_char * 1024),
	]
	def __init__(self):
		Structure.__init__(self)

	_o = AddressHolder()

	get_hex, r_asm_op_get_hex = register('r_asm_op_get_hex','c_void_p','c_char_p')
	get_asm, r_asm_op_get_asm = register('r_asm_op_get_asm','c_void_p','c_char_p')

class RAsmCode(Structure): #2
	_fields_ = [
		("len", c_int),
		("buf", POINTER(c_ubyte)),
		("buf_hex", c_char_p),
		("buf_asm", c_char_p),
	]
class RAsmPlugin(Structure): #3
	_fields_ = [
		("name", c_char_p),
		("arch", c_char_p),
		("desc", c_char_p),
		('bits', c_int * 0),
	]
class RNum(Structure): #4
	_fields_ = [
	]
	def __init__(self, cb, user):
		Structure.__init__(self)
		r_num_new = lib.r_num_new
		r_num_new.restype = c_void_p
		self._o = r_num_new (cb, user)

	_o = AddressHolder()

	get, r_num_get = register('r_num_get','c_void_p, c_char_p','c_ulonglong')
	math, r_num_math = register('r_num_math','c_void_p, c_char_p','c_ulonglong')

class RBuffer(Structure): #5
	_fields_ = [
		("buf", POINTER(c_ubyte)),
		("length", c_int),
		("cur", c_int),
		("base", c_ulonglong),
	]
	def __init__(self):
		Structure.__init__(self)
		r_buf_new = lib.r_buf_new
		r_buf_new.restype = c_void_p
		self._o = r_buf_new ()

	_o = AddressHolder()

	read_at, r_buf_read_at = register('r_buf_read_at','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_int')
	write_at, r_buf_write_at = register('r_buf_write_at','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_int')
	set_bytes, r_buf_set_bytes = register('r_buf_set_bytes','c_void_p, POINTER(c_ubyte), c_int','c_bool')

class RList(Structure): #6
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_list_new = lib.r_list_new
		r_list_new.restype = c_void_p
		self._o = r_list_new ()
	def to_list(self,type):
		return rlist2array(self,type)

	_o = AddressHolder()

	append, r_list_append = register('r_list_append','c_void_p, c_void_p',None)
	prepend, r_list_prepend = register('r_list_prepend','c_void_p, c_void_p',None)
	iterator, r_list_iterator = register('r_list_iterator','c_void_p','RListIter')
	length, r_list_length = register('r_list_length','c_void_p','c_uint')
	del_n, r_list_del_n = register('r_list_del_n','c_void_p, c_int','c_bool')
	get_top, r_list_get_top = register('r_list_get_top','c_void_p','c_bool')
	pop, r_list_pop = register('r_list_pop','c_void_p','c_void_p')

class RListIter(Structure): #7
	_fields_ = [
		("data", c_void_p),
		("n", c_void_p),
		("p", c_void_p),
	]
	def __init__(self):
		Structure.__init__(self)

	_o = AddressHolder()

	get_data, r_list_iter_get_data = register('r_list_iter_get_data','c_void_p','c_void_p')
	get_next, r_list_iter_get_next = register('r_list_iter_get_next','c_void_p','RListIter')

class RRange(Structure): #8
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_range_new = lib.r_range_new
		r_range_new.restype = c_void_p
		self._o = r_range_new ()
		r_range_new_from_string = lib.r_range_new_from_string
		r_range_new_from_string.restype = c_void_p
		self._o = r_range_new_from_string (str)

	_o = AddressHolder()

	item_get, r_range_item_get = register('r_range_item_get','c_void_p, c_ulonglong','POINTER(RRangeItem)')
	size, r_range_size = register('r_range_size','c_void_p','c_ulonglong')
	add_from_string, r_range_add_from_string = register('r_range_add_from_string','c_void_p, c_char_p','c_ulonglong')
	contains, r_range_contains = register('r_range_contains','c_void_p, c_ulonglong','c_bool')
	sort, r_range_sort = register('r_range_sort','c_void_p','c_bool')
	list, r_range_list = register('r_range_list','c_void_p, c_bool','c_bool')
	get_n, r_range_get_n = register('r_range_get_n','c_void_p, c_int, POINTER(c_ulonglong), POINTER(c_ulonglong)','c_bool')
	inverse, r_range_inverse = register('r_range_inverse','c_void_p, c_ulonglong, c_ulonglong, c_int','POINTER(RRange)')

class RRangeItem(Structure): #9
	_fields_ = [
		("fr", c_ulonglong),
		("to", c_ulonglong),
		("data", POINTER(c_ubyte)),
		("datalen", c_int),
	]
