% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot-long.R
\name{pivot_longer}
\alias{pivot_longer}
\title{Pivot data from wide to long}
\usage{
pivot_longer(
  data,
  cols,
  names_to = "name",
  names_prefix = NULL,
  names_sep = NULL,
  names_pattern = NULL,
  names_ptypes = list(),
  names_repair = "check_unique",
  values_to = "value",
  values_drop_na = FALSE,
  values_ptypes = list()
)
}
\arguments{
\item{data}{A data frame to pivot.}

\item{cols}{Columns to pivot into longer format. This takes a tidyselect
specification.}

\item{names_to}{A string specifying the name of the column to create
from the data stored in the column names of \code{data}.

Can be a character vector, creating multiple columns, if \code{names_sep}
or \code{names_pattern} is provided.}

\item{names_prefix}{A regular expression used to remove matching text
from the start of each variable name.}

\item{names_sep, names_pattern}{If \code{names_to} contains multiple values,
these arguments control how the column name is broken up.

\code{names_sep} takes the same specification as \code{\link[=separate]{separate()}}, and can either
be a numeric vector (specifying positions to break on), or a single string
(specifying a regular expression to split on).

\code{names_pattern} takes the same specification as \code{\link[=extract]{extract()}}, a regular
expression containing matching groups (\verb{()}).

If these arguments does not give you enough control, use
\code{pivot_longer_spec()} to create a spec object and process manually as
needed.}

\item{names_ptypes, values_ptypes}{A list of of column name-prototype pairs.
A prototype (or ptype for short) is a zero-length vector (like \code{integer()}
or \code{numeric()}) that defines the type, class, and attributes of a vector.

If not specified, the type of the columns generated from \code{names_to} will
be character, and the type of the variables generated from \code{values_to}
will be the common type of the input columns used to generate them.}

\item{names_repair}{What happen if the output has invalid column names?
The default, \code{"check_unique"} is to error if the columns are duplicated.
Use \code{"minimal"} to allow duplicates in the output, or \code{"unique"} to
de-duplicated by adding numeric suffixes. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}
for more options.}

\item{values_to}{A string specifying the name of the column to create
from the data stored in cell values. If \code{names_to} is a character
containing the special \code{.value} sentinel, this value will be ignored,
and the name of the value column will be derived from part of the
existing column names.}

\item{values_drop_na}{If \code{TRUE}, will drop rows that contain only \code{NA}s
in the \code{value_to} column. This effectively converts explicit missing values
to implicit missing values, and should generally be used only when missing
values in \code{data} were created by its structure.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

\code{pivot_longer()} "lengthens" data, increasing the number of rows and
decreasing the number of columns. The inverse transformation is
\code{\link[=pivot_wider]{pivot_wider()}}

Learn more in \code{vignette("pivot")}.
}
\details{
\code{pivot_longer()} is an updated approach to \code{\link[=gather]{gather()}}, designed to be both
simpler to use and to handle more use cases. We recomend you use
\code{pivot_longer()} for new code; \code{gather()} isn't going away but is no longer
under active development.
}
\examples{
# See vignette("pivot") for examples and explanation

# Simplest case where column names are character data
relig_income
relig_income \%>\%
 pivot_longer(-religion, names_to = "income", values_to = "count")

# Slightly more complex case where columns have common prefix,
# and missing missings are structural so should be dropped.
billboard
billboard \%>\%
 pivot_longer(
   cols = starts_with("wk"),
   names_to = "week",
   names_prefix = "wk",
   values_to = "rank",
   values_drop_na = TRUE
 )

# Multiple variables stored in colum names
who \%>\% pivot_longer(
  cols = new_sp_m014:newrel_f65,
  names_to = c("diagnosis", "gender", "age"),
  names_pattern = "new_?(.*)_(.)(.*)",
  values_to = "count"
)

# Multiple observations per row
anscombe
anscombe \%>\%
 pivot_longer(everything(),
   names_to = c(".value", "set"),
   names_pattern = "(.)(.)"
 )
}
