% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyglmzip.R
\name{svyglm.zip}
\alias{svyglm.zip}
\title{Survey-weighted zero-inflated Poisson model}
\usage{
svyglm.zip(formula, design, ...)
}
\arguments{
\item{formula}{An object of class \code{formula}, i.e. a symbolic description
of the model to be fitted. See 'Details' in \code{\link[pscl]{zeroinfl}}.}

\item{design}{An object of class \code{\link[survey]{svydesign}}, providing
a specification of the survey design.}

\item{...}{Other arguments passed down to \code{\link[pscl]{zeroinfl}}.}
}
\value{
An object of class \code{\link[survey]{svymle}} and \code{svyglm.zip},
          with some additional information about the model.
}
\description{
\code{svyglm.zip()} is an extension to the \CRANpkg{survey}-package
               to fit survey-weighted zero-inflated Poisson models. It uses
               \code{\link[survey]{svymle}} to fit sampling-weighted
               maximum likelihood estimates, based on starting values provided
               by \code{\link[pscl]{zeroinfl}}.
}
\details{
Code modified from https://notstatschat.rbind.io/2015/05/26/zero-inflated-poisson-from-complex-samples/.
}
\examples{
if (require("survey")) {
  data(nhanes_sample)
  set.seed(123)
  nhanes_sample$malepartners <- rpois(nrow(nhanes_sample), 2)
  nhanes_sample$malepartners[sample(1:2992, 400)] <- 0

  # create survey design
  des <- svydesign(
    id = ~SDMVPSU,
    strat = ~SDMVSTRA,
    weights = ~WTINT2YR,
    nest = TRUE,
    data = nhanes_sample
  )

  # fit negative binomial regression
  fit <- svyglm.zip(
    malepartners ~ age + factor(RIDRETH1) | age + factor(RIDRETH1),
    des
  )

  # print coefficients and standard errors
  fit
}
}
