% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov.mvr}
\alias{vcov.mvr}
\title{Calculate Variance-Covariance Matrix for a Fitted Model Object}
\usage{
\method{vcov}{mvr}(object, ncomp, ...)
}
\arguments{
\item{object}{a fitted PCR object of class \code{mvr}.}

\item{ncomp}{number of principal components to estimate \code{vcov} for.}

\item{...}{additional arguments (not used).}
}
\value{
A matrix of estimated covariances between regression coefficients.
}
\description{
Returns the variance-covariance matrix of the coefficients
of a Principal Component Regression.
}
\examples{
data(yarn)
yarn.pcr <- pcr(density ~ NIR, 6, data = yarn)
vc <- vcov(yarn.pcr, 3)

# Standard error of coefficients
se <- sqrt(diag(vc))
beta <- coef(yarn.pcr, ncomp = 3)

# Plot regression coefficients with two standard errors shading.
plot(beta, type = 'l',
     panel.first = polygon(x = c(1:268, 268:1),
                           y = c(beta+2*se, rev(beta-2*se)),
                           col = 'lightblue',
                           border = NA))
}
