% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.regression.R
\name{binregATE}
\alias{binregATE}
\alias{logitIPCWATE}
\alias{logitATE}
\alias{kumarsim}
\title{Average Treatment effect for censored competing risks data using Binomial Regression}
\usage{
binregATE(
  formula,
  data,
  cause = 1,
  time = NULL,
  beta = NULL,
  treat.model = ~+1,
  cens.model = ~+1,
  offset = NULL,
  weights = NULL,
  cens.weights = NULL,
  se = TRUE,
  kaplan.meier = TRUE,
  cens.code = 0,
  no.opt = FALSE,
  method = "nr",
  augmentation = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with outcome (see \code{coxph})}

\item{data}{data frame}

\item{cause}{cause of interest}

\item{time}{time of interest}

\item{beta}{starting values}

\item{treat.model}{logistic treatment model given covariates}

\item{cens.model}{only stratified cox model without covariates}

\item{offset}{offsets for partial likelihood}

\item{weights}{for score equations}

\item{cens.weights}{censoring weights}

\item{se}{to compute se's  with IPCW  adjustment, otherwise assumes that IPCW weights are known}

\item{kaplan.meier}{uses Kaplan-Meier for IPCW in contrast to exp(-Baseline)}

\item{cens.code}{gives censoring code}

\item{no.opt}{to not optimize}

\item{method}{for optimization}

\item{augmentation}{to augment binomial regression}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Under the standard causal assumptions  we can estimate the average treatment effect E(Y(1) - Y(0)). We need Consistency, ignorability ( Y(1), Y(0) indep A given X), and positivity.
}
\details{
The first covariate in the specification of the competing risks regression model must be the treatment effect that is binary.
This is then model using a logistic regresssion using  the standard binary double robust estimating equations that are
then IPCW censoring adjusted using binomial regression. 

Also computes the ATT and ATC, average treatment effect on the treated (ATT), E(Y(1) - Y(0) | A=1), and non-treated, respectively.

Rather than binomial regression we also consider a IPCW weighted version of standard logistic
regression logitIPCWATE.
}
\examples{
data(bmt)

brs <- binregATE(Event(time,cause)~tcell+platelet+age,bmt,time=50,cause=1,
  treat.model=tcell~platelet+age)
summary(brs)

}
\author{
Thomas Scheike
}
