% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-iid2.R
\name{iid2}
\alias{iid2}
\alias{iid2.lvmfit}
\alias{iid2.lvmfit2}
\alias{iid.lvmfit2}
\title{Influence Function With Small Sample Correction.}
\usage{
iid2(object, ...)

\method{iid2}{lvmfit}(
  object,
  robust = TRUE,
  cluster = NULL,
  as.lava = TRUE,
  ssc = lava.options()$ssc,
  ...
)

\method{iid2}{lvmfit2}(object, robust = TRUE, cluster = NULL, as.lava = TRUE, ...)

\method{iid}{lvmfit2}(x, robust = TRUE, cluster = NULL, as.lava = TRUE, ...)
}
\arguments{
\item{object, x}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}

\item{robust}{[logical] if \code{FALSE}, the influence function is rescaled such its the squared sum equals the model-based standard error (instead of the robust standard error).
Do not match the model-based correlation though.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.}

\item{as.lava}{[logical] if \code{TRUE}, uses the same names as when using \code{stats::coef}.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients (\code{"none"}, \code{"residual"}, \code{"cox"}). Only relevant when using a \code{lvmfit} object.}
}
\value{
A matrix containing the 1st order influence function relative to each sample (in rows)
and each model coefficient (in columns).
}
\description{
Extract the influence function from a latent variable model.
It is similar to \code{lava::iid} but with small sample correction.
}
\details{
When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the variance-covariance matrix.
}
\examples{
#### simulate data ####
n <- 5e1
p <- 3
X.name <- paste0("X",1:p)
link.lvm <- paste0("Y~",X.name)
formula.lvm <- as.formula(paste0("Y~",paste0(X.name,collapse="+")))

m <- lvm(formula.lvm)
distribution(m,~Id) <- Sequence.lvm(0)
set.seed(10)
d <- sim(m,n)

#### latent variable model ####
e.lvm <- estimate(lvm(formula.lvm),data=d)
iid.tempo <- iid2(e.lvm)


}
\seealso{
\code{\link{estimate2}} to obtain \code{lvmfit2} objects.
}
\concept{extractor}
\keyword{smallSampleCorrection}
