% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_with_lgl}
\alias{layout_with_lgl}
\alias{with_lgl}
\title{Large Graph Layout}
\usage{
layout_with_lgl(graph, maxiter = 150, maxdelta = vcount(graph),
  area = vcount(graph)^2, coolexp = 1.5, repulserad = area *
  vcount(graph), cellsize = sqrt(sqrt(area)), root = NULL)

with_lgl(...)
}
\arguments{
\item{graph}{The input graph}

\item{maxiter}{The maximum number of iterations to perform (150).}

\item{maxdelta}{The maximum change for a vertex during an iteration (the
number of vertices).}

\item{area}{The area of the surface on which the vertices are placed (square
of the number of vertices).}

\item{coolexp}{The cooling exponent of the simulated annealing (1.5).}

\item{repulserad}{Cancellation radius for the repulsion (the \code{area}
times the number of vertices).}

\item{cellsize}{The size of the cells for the grid. When calculating the
repulsion forces between vertices only vertices in the same or neighboring
grid cells are taken into account (the fourth root of the number of
\code{area}.}

\item{root}{The id of the vertex to place at the middle of the layout. The
default value is -1 which means that a random vertex is selected.}

\item{...}{Passed to \code{layout_with_lgl}.}
}
\value{
A numeric matrix with two columns and as many rows as vertices.
}
\description{
A layout generator for larger graphs.
}
\details{
\code{layout_with_lgl} is for large connected graphs, it is similar to the layout
generator of the Large Graph Layout software
(\url{http://lgl.sourceforge.net/}).
}
\seealso{
Other graph layouts: \code{\link{add_layout_}},
  \code{\link{component_wise}},
  \code{\link{layout_as_bipartite}},
  \code{\link{layout_as_star}},
  \code{\link{layout_as_tree}},
  \code{\link{layout_in_circle}},
  \code{\link{layout_nicely}},
  \code{\link{layout_on_grid}},
  \code{\link{layout_on_sphere}},
  \code{\link{layout_randomly}},
  \code{\link{layout_with_dh}},
  \code{\link{layout_with_fr}},
  \code{\link{layout_with_gem}},
  \code{\link{layout_with_graphopt}},
  \code{\link{layout_with_kk}},
  \code{\link{layout_with_mds}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{layout_}}, \code{\link{merge_coords}},
  \code{\link{norm_coords}}, \code{\link{normalize}}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{graph layouts}
\keyword{graphs}
