% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterise.R
\name{rasterize}
\alias{rasterize}
\title{Rasterise ggplot layers
Takes a ggplot object or a layer as input and renders their graphical output as a raster.}
\usage{
rasterize(input, ...)
}
\arguments{
\item{input}{ggplot plot object to rasterize}

\item{...}{ignored}
}
\value{
A modified \code{Layer} object.
}
\description{
Rasterise ggplot layers
Takes a ggplot object or a layer as input and renders their graphical output as a raster.
}
\details{
The default \code{dpi} (\code{NULL} (i.e. let the device decide)) can conveniently be controlled by setting the option \code{"ggrastr.default.dpi"} (e.g. \code{options("ggrastr.default.dpi" = 30)} for drafting).
}
\examples{
require(ggplot2)
# `rasterise()` is used to wrap layers
ggplot(pressure, aes(temperature, pressure)) +
  rasterise(geom_line())

# The `dpi` argument controls resolution
ggplot(faithful, aes(eruptions, waiting)) +
  rasterise(geom_point(), dpi = 5)

# The `dev` argument offers a few options for devices
require(ragg)
ggplot(diamonds, aes(carat, depth, z = price)) +
  rasterise(stat_summary_hex(), dev = "ragg")

# The `scale` argument allows you to render a 'big' plot in small window, or vice versa.
ggplot(faithful, aes(eruptions, waiting)) +
  rasterise(geom_point(), scale = 4)
}
\author{
Teun van den Brand <t.vd.brand@nki.nl>
}
