% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_stereo.R
\name{facet_stereo}
\alias{facet_stereo}
\title{Create a stereogram plot}
\usage{
facet_stereo(IPD = 63.5, panel.size = 200, shrink = TRUE)
}
\arguments{
\item{IPD}{The interpupillary distance (in mm) used for calculating point
displacement. The default value is an average of both genders}

\item{panel.size}{The final plot size in mm. As IPD this is used to calculate
point displacement. Don't take this value too literal but experiment until
you get a nice effect. Lower values gives higher displacement and thus
require the plots to be observed from a closer distance}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}
}
\description{
This, arguably pretty useless function, lets you create plots with a sense of
depth by creating two slightly different versions of the plot that
corresponds to how the eyes would see it if the plot was 3 dimensional. To
experience the effect look at the plots through 3D hardware such as Google
Cardboard or by relaxing the eyes and focusing into the distance. The
depth of a point is calculated for layers having a depth aesthetic supplied.
The scaling of the depth can be controlled with \code{\link[=scale_depth]{scale_depth()}} as
you would control any aesthetic. Negative values will result in features
placed behind the paper plane, while positive values will result in
features hovering in front of the paper. While features within each layer is
sorted so those closest to you are plotted on top of those more distant, this
cannot be done between layers. Thus, layers are always plotted on top of
each others, even if the features in one layer lies behind features in a
layer behind it. The depth experience is inaccurate and should not be used
for conveying important data. Regard this more as a party-trick...
}
\examples{
# You'll have to accept a warning about depth being an unknown aesthetic
ggplot(mtcars) +
  geom_point(aes(mpg, disp, depth = cyl)) +
  facet_stereo()
}
\seealso{
Other ggforce facets: \code{\link{facet_grid_paginate}},
  \code{\link{facet_wrap_paginate}},
  \code{\link{facet_zoom}}
}
\concept{ggforce facets}
