% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-subset-slice.R
\name{slice.dtplyr_step}
\alias{slice.dtplyr_step}
\alias{slice_head.dtplyr_step}
\alias{slice_tail.dtplyr_step}
\alias{slice_min.dtplyr_step}
\alias{slice_max.dtplyr_step}
\title{Subset rows using their positions}
\usage{
\method{slice}{dtplyr_step}(.data, ..., .by = NULL)

\method{slice_head}{dtplyr_step}(.data, ..., n, prop, by = NULL)

\method{slice_tail}{dtplyr_step}(.data, ..., n, prop, by = NULL)

\method{slice_min}{dtplyr_step}(.data, order_by, ..., n, prop, by = NULL, with_ties = TRUE)

\method{slice_max}{dtplyr_step}(.data, order_by, ..., n, prop, by = NULL, with_ties = TRUE)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{For \code{slice()}: <\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Integer row
values.

Provide either positive values to keep, or negative values to drop.
The values provided must be either all positive or all negative.
Indices beyond the number of rows in the input are silently ignored.

For \verb{slice_*()}, these arguments are passed on to methods.}

\item{.by, by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{n, prop}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used. If \code{n} is greater than the number of rows in the group
(or \code{prop > 1}), the result will be silently truncated to the group size.
\code{prop} will be rounded towards zero to generate an integer number of
rows.

A negative value of \code{n} or \code{prop} will be subtracted from the group
size. For example, \code{n = -2} with a group of 5 rows will select 5 - 2 = 3
rows; \code{prop = -0.25} with 8 rows will select 8 * (1 - 0.25) = 6 rows.}

\item{order_by}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Variable or function
of variables to order by. To order by multiple variables, wrap them in a
data frame or tibble.}

\item{with_ties}{Should ties be kept together? The default, \code{TRUE},
may return more rows than you request. Use \code{FALSE} to ignore ties,
and return the first \code{n} rows.}
}
\description{
These are methods for the dplyr \code{\link[=slice]{slice()}}, \code{slice_head()}, \code{slice_tail()},
\code{slice_min()}, \code{slice_max()} and \code{slice_sample()} generics. They are
translated to the \code{i} argument of \verb{[.data.table}.

Unlike dplyr, \code{slice()} (and \code{slice()} alone) returns the same number of
rows per group, regardless of whether or not the indices appear in each
group.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

dt <- lazy_dt(mtcars)
dt \%>\% slice(1, 5, 10)
dt \%>\% slice(-(1:4))

# First and last rows based on existing order
dt \%>\% slice_head(n = 5)
dt \%>\% slice_tail(n = 5)

# Rows with minimum and maximum values of a variable
dt \%>\% slice_min(mpg, n = 5)
dt \%>\% slice_max(mpg, n = 5)

# slice_min() and slice_max() may return more rows than requested
# in the presence of ties. Use with_ties = FALSE to suppress
dt \%>\% slice_min(cyl, n = 1)
dt \%>\% slice_min(cyl, n = 1, with_ties = FALSE)

# slice_sample() allows you to random select with or without replacement
dt \%>\% slice_sample(n = 5)
dt \%>\% slice_sample(n = 5, replace = TRUE)

# you can optionally weight by a variable - this code weights by the
# physical weight of the cars, so heavy cars are more likely to get
# selected
dt \%>\% slice_sample(weight_by = wt, n = 5)
}
