% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-logical.R
\name{chk_logical}
\alias{chk_logical}
\alias{vld_logical}
\title{Check Logical}
\usage{
chk_logical(x, x_name = NULL)

vld_logical(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if logical using

\code{is.logical(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_logical()}: Validate Logical

}}
\examples{
# chk_logical
chk_logical(TRUE)
try(chk_logical(1))
# vld_logical
vld_logical(TRUE)
vld_logical(matrix(TRUE))
vld_logical(logical(0))
vld_logical(NA)
vld_logical(1)
vld_logical("TRUE")
}
\seealso{
Other chk_typeof: 
\code{\link{chk_character_or_factor}()},
\code{\link{chk_character}()},
\code{\link{chk_count}()},
\code{\link{chk_double}()},
\code{\link{chk_environment}()},
\code{\link{chk_factor}()},
\code{\link{chk_integer}()},
\code{\link{chk_list}()}
}
\concept{chk_typeof}
