% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_tidiers.R
\name{tidy_vgam}
\alias{tidy_vgam}
\title{Tidy a \code{vglm} or a \code{vgam} model}
\usage{
tidy_vgam(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{(\code{vglm} or \code{vgam})\cr
A \code{VGAM::vglm()} or a \code{VGAM::vgam()} model.}

\item{conf.int}{(\code{logical})\cr
Whether or not to include a confidence interval in the tidied output.}

\item{conf.level}{(\code{numeric})\cr
The confidence level to use for the confidence interval (between \code{0} ans \code{1}).}

\item{...}{Additional parameters passed to \code{parameters::model_parameters()}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A tidier for models generated with \code{VGAM::vglm()} or \code{VGAM::vgam()}.
Term names will be updated to be consistent with generic models. The original
term names are preserved in an \code{"original_term"} column. Depending on the
model, additional column \code{"group"}, \code{"component"} and/or \code{"y.level"} may be
added to the results.
}
\examples{
\dontshow{if (.assert_package("VGAM", boolean = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
  library(VGAM)
  mod <- vglm(
    Species ~ Sepal.Length + Sepal.Width,
    family = multinomial(),
    data = iris
  )
  mod |> tidy_vgam(exponentiate = TRUE)
  mod <- vglm(
    Species ~ Sepal.Length + Sepal.Width,
    family = multinomial(parallel = TRUE),
    data = iris
  )
  mod |> tidy_vgam(exponentiate = TRUE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other custom_tieders: 
\code{\link{tidy_broom}()},
\code{\link{tidy_multgee}()},
\code{\link{tidy_parameters}()},
\code{\link{tidy_with_broom_or_parameters}()},
\code{\link{tidy_zeroinfl}()}
}
\concept{custom_tieders}
