% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigmemory.R
\docType{class}
\name{big.matrix.descriptor-class}
\alias{big.matrix.descriptor-class}
\alias{attach.resource,character-method}
\alias{attach.resource,big.matrix.descriptor-method}
\title{Class "big.matrix.descriptor"}
\usage{
\S4method{attach.resource}{character}(obj, ...)

\S4method{attach.resource}{big.matrix.descriptor}(obj, ...)
}
\arguments{
\item{obj}{The filename of the descriptor for a filebacked matrix,
assumed to be in the directory specified}

\item{...}{possibly \code{path} which gives the path where the descriptor
and/or filebacking can be found.}
}
\description{
An object of this class contains necessary and sufficient information
to ``attach'' a shared or filebacked \code{\link{big.matrix}}.
}
\note{
We provide \code{attach.resource} for convenience, but expect most users
will prefer \code{\link{attach.big.matrix}}.
}
\section{Objects from the Class}{

Objects should not be created by calls of the form \code{new("big.matrix.descriptor", ...)},
but should use the \code{\link{describe}} function.
}

\section{Slots}{

\describe{
\item{\code{description}:}{Object of class \code{"list"}; details omitted.}
}
}

\section{Extends}{

Class \code{"descriptor"}, directly.
}

\section{Methods}{

\describe{
\item{attach.resource}{\code{signature(obj = "big.matrix.descriptor")}: ... }
\item{sub.big.matrix}{\code{signature(x = "big.matrix.descriptor")}: ... }
}
}

\examples{
showClass("big.matrix.descriptor")
}
\references{
Other types of descriptors are defined in package \pkg{synchronicity}.
}
\seealso{
See also \code{\link{attach.big.matrix}}.
}
\author{
John W. Emerson and Michael J. Kane
}
\keyword{classes}
