% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreakpointGRanges.R
\name{countBreakpointOverlaps}
\alias{countBreakpointOverlaps}
\title{Counting overlapping breakpoints between two breakpoint sets}
\usage{
countBreakpointOverlaps(
  querygr,
  subjectgr,
  countOnlyBest = FALSE,
  breakpointScoreColumn = "QUAL",
  maxgap = -1L,
  minoverlap = 0L,
  ignore.strand = FALSE,
  sizemargin = NULL,
  restrictMarginToSizeMultiple = NULL
)
}
\arguments{
\item{querygr, subjectgr, maxgap, minoverlap, ignore.strand, sizemargin, restrictMarginToSizeMultiple}{See \code{findBreakpointOverlaps()}.}

\item{countOnlyBest}{Default value set to FALSE. When set to TRUE, the result count
each subject breakpoint as overlaping only the best overlapping query breakpoint.
The best breakpoint is considered to be the one with the highest QUAL score.}

\item{breakpointScoreColumn}{Query column defining a score for determining which query breakpoint
is considered the best when countOnlyBest=TRUE.}
}
\value{
An integer vector containing the tabulated query overlap hits.
}
\description{
Counting overlapping breakpoints between two breakpoint sets
}
\details{
\code{countBreakpointOverlaps()} returns the number of overlaps between breakpoint
objects, based on the output of \code{findBreakpointOverlaps()}.
See GenomicRanges::countOverlaps-methods
}
\examples{
truth_vcf = VariantAnnotation::readVcf(system.file("extdata", "na12878_chr22_Sudmunt2015.vcf", 
package = "StructuralVariantAnnotation"))
crest_vcf = VariantAnnotation::readVcf(system.file("extdata", "na12878_chr22_crest.vcf", 
package = "StructuralVariantAnnotation"))
caller_bpgr = breakpointRanges(crest_vcf)
caller_bpgr$true_positive = countBreakpointOverlaps(caller_bpgr, breakpointRanges(truth_vcf),
  maxgap=100, sizemargin=0.25, restrictMarginToSizeMultiple=0.5, countOnlyBest=TRUE)
}
