write.csv(file="../../extdata/2.6.0/metadata-nowakowski-cortex.csv",
    data.frame(
        Title = sprintf("Nowakowski cortex %s", c("TPMs", "colData", "reducedDims")),
        Description = sprintf("%s for the Nowakowski cortex single-cell RNA-seq dataset", 
            c("TPM matrix", "Per-cell metadata", "Reduced dimensions")),
        RDataPath = file.path("scRNAseq", "nowakowski-cortex", "2.6.0", 
            c("tpm.rds", "coldata.rds", "reddims.rds")),
        BiocVersion="3.13",
        Genome="hg38",
        SourceType="TSV",
        SourceUrl="http://cells.ucsc.edu/?ds=cortex-dev",
        SourceVersion=c(
            "exprMatrix.tsv.gz",
            "meta.tsv",
            "tMinusSNE_on_WGCNA.coords.tsv.gz;TriMap.coords.tsv.gz;TMinusSNE_scanpy.coords.tsv.gz;UMAP_scanpy.coords.tsv.gz;PAGAPlusForceAtlas2_scanpy.coords.tsv.gz"),
        Species="Homo sapiens",
        TaxonomyId="9606",
        Coordinate_1_based=NA,
        DataProvider="GEO",
        Maintainer="Aaron Lun <infinite.monkeys.with.keyboards@gmail.com>",
        RDataClass=c("dgCMatrix", "DFrame", "list"),
        DispatchClass="Rds",
        stringsAsFactors = FALSE
    ),
    row.names=FALSE)
