% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/314-extractDrugBondCount.R
\name{extractDrugBondCount}
\alias{extractDrugBondCount}
\title{Calculate the Descriptor Based on the Number of Bonds of a
Certain Bond Order}
\usage{
extractDrugBondCount(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{nB}.
}
\description{
Calculate the Descriptor Based on the Number of Bonds of a
Certain Bond Order
}
\details{
Calculates the descriptor based on the number of bonds of a
certain bond order.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugBondCount(mol)
head(dat)}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Bond}
\keyword{Count}
\keyword{extractDrugBondCount}
