% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progenySuppFunc.r
\name{saveProgenyPlots}
\alias{saveProgenyPlots}
\title{Function to save Progeny plots}
\usage{
saveProgenyPlots(plots, contrast_names, dirpath)
}
\arguments{
\item{plots}{a list of list of arrangeGrob object (such as the one returned 
by the progenyScatter function.).The first level list elements correspond 
to samples/contrasts. The second level corresponds to pathways.
The plots can be saved in a pdf format using the saveProgenyPlots function.}

\item{contrast_names}{a vector of the same length as the first level of 
the plot list corresponding to the names of each sample/contrast}

\item{dirpath}{the path to the directory where the plots should be saved}
}
\value{
This function produces the pdf files of plots taken from the 
progenyScatter function
}
\description{
This function is designed to save the plots (in pdf format) of a nested 
(2 level) list of arrangeGrob objects, such as the one returned by 
the progenyScatter function.
}
\examples{
#create plots using progneyScatter function
gene_expression <- read.csv(system.file("extdata", 
"human_input.csv", package = "progeny"))

# getting a weight_matrix
weight_matrix <- getModel("Human", top=100)
weight_matrix <- data.frame(names = row.names(weight_matrix), 
  row.names = NULL, weight_matrix) 
plots <- progenyScatter(gene_expression, weight_matrix)

#create a list with contrast names
contrast_names <- names(gene_expression[2:ncol(gene_expression)])

#assign a path to store your plots
dirpath <- "./progeny_plots/"

# save it
# saveProgenyPlots(plots, contrast_names, dirpath)
}
