% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial_test.R
\name{binomial_test}
\alias{binomial_test}
\title{Binomial test for enrichment or depletion testing}
\usage{
binomial_test(p, n, x, p_cutoffs = 0.05)
}
\arguments{
\item{p}{Probability of success}

\item{n}{Number of trials}

\item{x}{Observed number of successes}

\item{p_cutoffs}{Significance cutoff for the p value. Default: 0.05}
}
\value{
A data.frame with direction of effect (enrichment/depletion),
P-value and significance asterisks
}
\description{
This function performs lower-tail binomial test for depletion and
upper-tail test for enrichment
}
\examples{
binomial_test(0.5, 1200, 543)
binomial_test(0.2, 800, 150)
}
