% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpt-methods.r
\name{DPT methods}
\alias{DPT methods}
\alias{dataset.DPT}
\alias{branch_divide}
\alias{tips}
\alias{dataset,DPT-method}
\alias{dataset<-,DPT-method}
\title{DPT methods}
\usage{
branch_divide(dpt, divide = integer(0L))

tips(dpt)

\S4method{dataset}{DPT}(object)

\S4method{dataset}{DPT}(object) <- value
}
\arguments{
\item{dpt, object}{DPT object}

\item{divide}{Vector of branch numbers to use for division}

\item{value}{Value of slot to set}
}
\value{
\code{branch_divide} and \code{dataset<-} return the changed object, \code{dataset} the extracted data, and \code{tips} the tip indices.
}
\description{
Methods for the \link{DPT} class. \code{branch_divide} subdivides branches for plotting (see the examples).
}
\examples{
data(guo_norm)
dpt <- DPT(DiffusionMap(guo_norm))
dpt_9_branches <- branch_divide(dpt, 1:3)
plot(dpt_9_branches, col_by = 'branch')

}
\seealso{
\link{plot.DPT} uses \code{branch_divide} for its \code{divide} argument.
}
