/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKEIMAGECAPTURECONTROL_H
#define FAKEIMAGECAPTURECONTROL_H

#include <QCameraImageCaptureControl>
#include <storagemanager.h>

class FakeCameraService;
class FakeCameraControl;
class QThread;

class SaveJpegWorker: public QObject
{
    Q_OBJECT
public Q_SLOTS:
    void saveJpeg(QImage image, const QString &fileName);

Q_SIGNALS:
    void saveDone();
};


class FakeImageCaptureControl : public QCameraImageCaptureControl
{
Q_OBJECT
public:
    FakeImageCaptureControl(FakeCameraService *service, QObject *parent = 0);
    ~FakeImageCaptureControl();

    int capture(const QString &fileName);
    void cancelCapture();

    bool isReadyForCapture() const;

    QCameraImageCapture::DriveMode driveMode() const { return QCameraImageCapture::SingleImageCapture; }
    void setDriveMode(QCameraImageCapture::DriveMode ) {}

private Q_SLOTS:
    void updateReady();
    void performPreview();
    void performCapture();
    void saveDone();

private:
    FakeCameraService *m_service;
    FakeCameraControl *m_cameraControl;
    int m_lastRequestId;
    QString m_pendingCaptureFile;
    StorageManager m_storageManager;
    bool m_ready;
    QThread *m_saveThread;
    SaveJpegWorker *m_saveWorker;
};

#endif
