/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fakecameracontrol.h"
#include "fakecameraflashcontrol.h"
#include "fakecamerafocuscontrol.h"
#include "fakecameraservice.h"
#include "fakecamerazoomcontrol.h"
#include "fakeimagecapturecontrol.h"
#include "fakemediarecordercontrol.h"
#include "fakevideodeviceselectorcontrol.h"
#include "fakevideorenderercontrol.h"
#include "fakeviewfindersettingscontrol.h"

#include <QDebug>

FakeCameraService::FakeCameraService(QObject *parent):
    QMediaService(parent),
    m_videoOutput(0)
{
    m_cameraControl = new FakeCameraControl(this);
    m_flashControl = new FakeCameraFlashControl(this);
    m_focusControl = new FakeCameraFocusControl(this);
    m_zoomControl = new FakeCameraZoomControl(this);
    m_imageCaptureControl = new FakeImageCaptureControl(this);
    m_recorderControl = new FakeMediaRecorderControl(this);
    m_deviceSelectControl = new FakeVideoDeviceSelectorControl(this);
    m_videoOutput = new FakeVideoRendererControl(this);
    m_viewfinderControl = new FakeViewfinderSettingsControl(this);
}

FakeCameraService::~FakeCameraService()
{
    m_cameraControl->setState(QCamera::UnloadedState);
    delete m_cameraControl;
    delete m_flashControl;
    delete m_focusControl;
    delete m_zoomControl;
    delete m_imageCaptureControl;
    delete m_recorderControl;
    delete m_deviceSelectControl;
    delete m_videoOutput;
    delete m_viewfinderControl;
}

QMediaControl *FakeCameraService::requestControl(const char *name)
{
    if (qstrcmp(name, QCameraControl_iid) == 0)
        return m_cameraControl;

    if (qstrcmp(name, QCameraFlashControl_iid) == 0)
        return m_flashControl;

    if (qstrcmp(name, QCameraFocusControl_iid) == 0)
        return m_focusControl;

    if (qstrcmp(name, QCameraImageCaptureControl_iid) == 0)
        return m_imageCaptureControl;

    if (qstrcmp(name, QCameraZoomControl_iid) == 0)
        return m_zoomControl;

    if (qstrcmp(name, QMediaRecorderControl_iid) == 0)
        return m_recorderControl;

    if (qstrcmp(name, QVideoDeviceSelectorControl_iid) == 0)
        return m_deviceSelectControl;

    if (qstrcmp(name, QVideoRendererControl_iid) == 0)
        return m_videoOutput;

    if (qstrcmp(name, QCameraViewfinderSettingsControl_iid) == 0)
        return m_viewfinderControl;

    return 0;
}

void FakeCameraService::releaseControl(QMediaControl *control)
{
    Q_UNUSED(control);
}
