/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef SINGLEMESSAGE_H
#define SINGLEMESSAGE_H

#include <message.h>

class SingleMessageWgt;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class SingleMessage : public Message
{
  private:
    SingleMessageWgt* m_messageWgt;
    bool m_isNew;

  public:
    SingleMessage(QC_DatagramHeader* Hdr = 0, quint64 = 0);
    ~SingleMessage();

    void setMessageWgt( SingleMessageWgt* theValue ){m_messageWgt = theValue;}
    SingleMessageWgt* messageWgt() const {return m_messageWgt;}
    bool activate();

    void setOld(){m_isNew = false;}
    void setNew(){m_isNew = true;}
    bool isNew() const {return m_isNew;}

};

#endif
