# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import SubscriptionClientConfiguration
from .operations import SubscriptionsOperations
from .operations import SubscriptionOperationOperations
from .operations import SubscriptionFactoryOperations
from .operations import SubscriptionOperations
from .operations import Operations
from .operations import TenantsOperations
from . import models


class SubscriptionClient(SDKClient):
    """The subscription client

    :ivar config: Configuration for client.
    :vartype config: SubscriptionClientConfiguration

    :ivar subscriptions: Subscriptions operations
    :vartype subscriptions: azure.mgmt.subscription.operations.SubscriptionsOperations
    :ivar subscription_operation: SubscriptionOperation operations
    :vartype subscription_operation: azure.mgmt.subscription.operations.SubscriptionOperationOperations
    :ivar subscription_factory: SubscriptionFactory operations
    :vartype subscription_factory: azure.mgmt.subscription.operations.SubscriptionFactoryOperations
    :ivar subscription_operations: SubscriptionOperations operations
    :vartype subscription_operations: azure.mgmt.subscription.operations.SubscriptionOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.subscription.operations.Operations
    :ivar tenants: Tenants operations
    :vartype tenants: azure.mgmt.subscription.operations.TenantsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        self.config = SubscriptionClientConfiguration(credentials, base_url)
        super(SubscriptionClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.subscriptions = SubscriptionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.subscription_operation = SubscriptionOperationOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.subscription_factory = SubscriptionFactoryOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.subscription_operations = SubscriptionOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.tenants = TenantsOperations(
            self._client, self.config, self._serialize, self._deserialize)
