# browsing.py
# Copyright (C) 2008-2009 Stefan J. Betz <info@stefan-betz.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Stdlib Imports
from threading import Thread
# PyGtk Imports
from gtk.gdk import threads_enter, threads_leave
# pyNeighborhood Imports
from pyneighborhood import config, db, dblock
from pyneighborhood.misc import print_debug, print_database
from pyneighborhood.nmblookup import query_masters, query_workgroup, query_workgroup_hosts, query_host
from pyneighborhood.smbclient import scan_shares

class BrowsingThread(Thread):
    """
    Browsing Class
    """

    def __init__(self, mainwindow = None):
        """
        Constructor
        """
        Thread.__init__(self)
        self.mainwindow = mainwindow

    def run(self):
        """
        Browse me...
        """
        print_debug("Starting Browsing Engine...")
        dblock.acquire()
        cursor = db.cursor()
        cursor.execute("""UPDATE workgroups SET validated = 0 WHERE manual = 0""")
        cursor.execute("""UPDATE hosts SET validated = 0 WHERE manual = 0""")
        cursor.execute("""UPDATE shares SET validated = 0 WHERE manual = 0""")
        dblock.release()
        for master in query_masters():
            print_debug("Found Master Browser: %s" % master)
            workgroup, workgroupid = query_workgroup(master)
            print_debug("Master Browser %s has Workgroup %s" % ( master, workgroup ))
            for host in query_workgroup_hosts(workgroup):
                query_host(host)
        cur = db.cursor()
        workgroups_result = cur.execute("""SELECT name FROM workgroups WHERE manual = 0""").fetchall()
        for result in workgroups_result:
            print_debug("Found workgroup: %s" % result[0])
        hosts_result = cur.execute("""SELECT id,name,ip FROM hosts WHERE manual = 0""").fetchall()
        for result in hosts_result:
            print_debug("Scanning host %s for shares..." % result[1] )
            scan_shares(result[2])
            shares_result = cur.execute("""SELECT * FROM shares WHERE host = ? AND manual = 0""", (result[0],)).fetchall()
            for share in shares_result:
                print_debug("Found share: %s" % str(share))
        if self.mainwindow != None:
            threads_enter()
            self.mainwindow.sync_treeview()
            threads_leave()
            dblock.acquire()
            cur.execute("""DELETE FROM shares WHERE validated = 0 AND manual = 0""")
            cur.execute("""DELETE FROM hosts WHERE validated = 0 AND manual = 0""")
            cur.execute("""DELETE FROM workgroups WHERE validated = 0 AND manual = 0""")
            dblock.release()
            print_database(db)
