"""
Unit Test Case
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: testMainController.py 82 2004-07-11 13:01:44Z henning $

import unittest
from MainController import MainController
from vcard import vCard, FIELDNAMES
from testvcard import fillDemoCard
import Preferences

class MainControllerTestCase(unittest.TestCase):
    TESTFN = '*MainController TestCase Card %d*'
    TESTCATEGORIES = 'TestCase, MainController, Private'
    TESTFN2 = 'Will be deleted soon..'
    TESTCATEGORIES2 = u'Delete me, TestCase, Umlaut\xe4' 
    def setUp(self):
        self.mainctrl = MainController(nogui=1, nouserpref=1)
        import tempfile
        self.tempfilename = tempfile.mktemp()
        self.democard = vCard()
        fillDemoCard(self.democard)
 
    def tearDown(self):
        self.mainctrl.CleanUp()
        import os
        try:
            os.unlink(self.tempfilename)
            os.unlink(self.tempfilename+'.ics')
        except OSError:
            pass

    def testContactOperationsXMLRPC(self):
        "some random operations on MainModel (stress test) using XMLRPC"
        # Use port 8811 instead of 8810 to avoid collision with 
        # any running non-testing server:
        Preferences.set("client.connection_type", "xmlrpc")
        Preferences.set("client.connection_string", "http://localhost:8811")
        Preferences.set("client.autostart_server", "yes")
        Preferences.set("server.listen_host", "localhost")
        Preferences.set("server.listen_port", "8811")
        Preferences.set("server.addressbook_filename", self.tempfilename)
        Preferences.set("server.calendar_filename", self.tempfilename+'.ics')
        self.mainctrl.Run()
        self._testContactOperations()
        print "The test server is still running."
        print "Please kill the process manually!"
        
    def testContactOperationsFile(self):
        "some random operations on MainModel (stress test) using direct file"
        Preferences.set("client.connection_type", "file")
        Preferences.set("client.connection_string", self.tempfilename)
        Preferences.set("client.autostart_server", "no")
        self.mainctrl.Run()
        self._testContactOperations()

    def _testContactOperations(self):
        "some random operations on MainModel (stress test)"
        import random
        for j in range(3):
            handles = []
            for i in range(10):
                hdl = self.mainctrl.model.NewContact({'fn':self.TESTFN % i})
                handles.append(hdl)
                card = self.mainctrl.model.GetContact(hdl)
                self.assertEquals(card.fn.get(), self.TESTFN % i)
            for i in range(10):
                hdl = random.choice(handles)
                field = random.choice(FIELDNAMES)
                # Revision-DateTime will be altered by server:
                while field == "Rev":
                    field = random.choice(FIELDNAMES)
                self.mainctrl.model.PutContact(hdl, self.democard.VCF_repr())
                card = self.mainctrl.model.GetContact(hdl)
                self.assertEquals(card.getFieldValueStr(field),
                    self.democard.getFieldValueStr(field))
            for i in range(random.randint(0, 10)):
                self.mainctrl.model.DelContact(handles[i])


if __name__ == "__main__":
    unittest.main()
