#-*- coding:utf-8 -*-

#  Copyright © 2009, 2011-2015  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.



import os, sys

N_ = lambda s: s

AUTHOR = 'B. Clausius'
CONTACT_EMAIL = 'barcc@gmx.de'
CONTACT_WEB = 'https://answers.launchpad.net/pybik'
COPYRIGHT = 'Copyright © 2009-2015,  B. Clausius'
LICENSE_NAME = 'GPL-3+'
PACKAGE = 'pybik'
# Name of the application, probably should not be translated.
APPNAME = N_('Pybik')
VERSION = '2.1'
WEBSITE = 'https://launchpad.net/pybik/'
DOWNLOADS = 'https://launchpad.net/pybik/+download'
BUG_DATABASE = 'https://bugs.launchpad.net/pybik'
CONTACT_FILEBUG = BUG_DATABASE + '/+filebug'


# The following two lines are replaced by "setup.py install"
data_dir = os.path.join(os.path.dirname(os.path.dirname(__file__)), 'data')
appdata_dir = data_dir
# The following line is replaced by "setup.py sdist"
RELEASE_DATE = '2015-07-29'

LOCALE_DIR   = os.path.join(data_dir, 'locale')
QT_LOCALE_DIR = os.path.join(sys.prefix, 'share', 'qt5', 'translations')
APPICON_FILE = os.path.join(appdata_dir, 'icons', 'pybik-64.png')
APPICON192_FILE = os.path.join(appdata_dir, 'icons', 'pybik-192.png')
LICENSE_FILE = os.path.join(appdata_dir, 'GPL-3')
MODELS_DIR   = os.path.join(appdata_dir, 'models')
PLUGINS_DIR  = os.path.join(appdata_dir, 'plugins')
UI_DIR       = os.path.join(appdata_dir, 'ui')
TESTDATA_DIR = os.path.join(appdata_dir, 'tests')
SHADER_DIR = os.path.join(appdata_dir, 'shaders')

def get_testdatafiles():
    return [f for f in os.listdir(TESTDATA_DIR) if not f.endswith('~')]
    
def get_config_home():
    return os.environ.get('XDG_CONFIG_HOME', '') or os.path.expanduser("~/.config")
def get_data_home():
    return os.environ.get('XDG_DATA_HOME', '') or os.path.expanduser("~/.local/share")
    
USER_CONFIG_DIR    = os.path.join(get_config_home(), PACKAGE)
USER_DATA_DIR      = os.path.join(get_data_home(), PACKAGE)
USER_SETTINGS_FILE = os.path.join(USER_CONFIG_DIR, 'settings.conf')
USER_PLUGINS_DIR   = os.path.join(USER_DATA_DIR, 'plugins')
USER_GAMES_FILE    = os.path.join(USER_DATA_DIR, 'games')

SHORT_DESCRIPTION = N_("Rubik's cube game")
LONG_DESCRIPTION = (
    # The next 7 lines belong together and form the long description
    N_('Pybik is a 3D puzzle game about the cube invented by Ernő Rubik.'),
    N_('* Different 3D puzzles - up to 10x10x10:'),
    N_('  cubes, towers, bricks, tetrahedra and prisms'),
    N_('* Solvers for some puzzles'),
    N_('* Pretty patterns'),
    N_('* Editor for move sequences'),
    N_('* Changeable colors and images'),
)

LICENSE_INFO = N_(
            'This program is free software: you can redistribute it and/or modify '
            'it under the terms of the GNU General Public License as published by '
            'the Free Software Foundation, either version 3 of the License, or '
            '(at your option) any later version.\n\n'

            'This program is distributed in the hope that it will be useful, '
            'but WITHOUT ANY WARRANTY; without even the implied warranty of '
            'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the '
            'GNU General Public License for more details.')
LICENSE_FURTHER = N_(
# Text between "<" and ">" is expanded to a link by the program and should not be modified.
# Text between "<LINK|>" and "<|>" is the translatable text for the link.
            'Read the full text of the <text:FULL_LICENSE_TEXT|>GNU General Public License'
            '<|> or see <http://www.gnu.org/licenses/>.')
LICENSE_NOT_FOUND = N_(
            'You should have received a copy of the GNU General Public License'
            ' along with this program.  If not, see <http://www.gnu.org/licenses/>.')

def get_filebug_text():
    return _(
    # "Wishlist" is used on Launchpad for Importance, so this word should probably not be translated
    'If you find any bugs in Pybik or have a suggestion for an improvement then please '
    'submit a <{CONTACT_FILEBUG}|>bug report<|>. '
    'In the latter case you can mark the bug report as "Wishlist".'
    ).format(CONTACT_FILEBUG=CONTACT_FILEBUG)

TRANSLATION_TEXT = N_(
    'Translations are managed by the '
    '<https://translations.launchpad.net/+groups/launchpad-translators|>'
    'Launchpad translation group<|>.\n\n'
    'If you want help to translate Pybik to your language you can do it through '
    'the <https://translations.launchpad.net/pybik|>web interface<|>.\n\n'
    'Read more about <https://help.launchpad.net/Translations|>"Translating with Launchpad"<|> '
    'and <https://help.launchpad.net/Translations/StartingToTranslate|>"Starting to translate"<|>.')

REPOSITORY_SHORT = 'lp:pybik'
REPOSITORY_URL = 'https://code.launchpad.net/~barcc/pybik/trunk'
REPOSITORY_BROWSE = 'https://bazaar.launchpad.net/~barcc/pybik/trunk/files'


