# == Class designate::sink
#
# Configure designate sink service
#
# == Parameters
#
# [*package_ensure*]
#  (optional) The state of the package
#  Defaults to 'present'
#
# [*sink_package_name*]
#  (optional) Name of the package containing sink resources
#  Defaults to $::designate::params::sink_package_name
#
# [*enabled*]
#  (optional) Whether to enable services.
#  Defaults to true
#
# [*manage_service*]
#   (Optional) Whether the designate sink service will be managed.
#   Defaults to true.
#
# [*enabled_notification_handlers*]
#  (optional) List of notification handlers to enable, configuration of
#  these needs to correspond to a [handler:my_driver] section below or
#  else in the config.
#  Defaults to undef
#
# DEPRECATED PARAMETERS
#
# [*service_ensure*]
#  (optional) Whether the designate sink service will be running.
#  Defaults to 'DEPRECATED'
#
class designate::sink (
  $package_ensure                = present,
  $sink_package_name             = $::designate::params::sink_package_name,
  $enabled                       = true,
  $manage_service                = true,
  $enabled_notification_handlers = undef,
  # DEPRECATED PARAMETERS
  $service_ensure               = 'DEPRECATED',
) inherits designate {

  include designate::deps

  if $service_ensure != 'DEPRECATED' {
    warning('The service_ensure parameter is deprecated. Use the manage_service parameter.')
    $manage_service_real = $service_ensure
  } else {
    $manage_service_real = $manage_service
  }

  designate::generic_service { 'sink':
    enabled        => $enabled,
    manage_service => $manage_service_real,
    package_ensure => $package_ensure,
    package_name   => $sink_package_name,
    service_name   => $::designate::params::sink_service_name,
  }

  if $enabled_notification_handlers {
    designate_config {
      'service:sink/enabled_notification_handlers':  value => join($enabled_notification_handlers,',')
    }
  } else {
    designate_config {
      'service:sink/enabled_notification_handlers':  ensure => absent
    }
  }

}
