# PMIx Reference Library (OpenPMIx)

## Official documentation

The OpenPMIx documentation can be viewed in the following ways:

1. Online at https://docs.openpmix.org/
1. In self-contained (i.e., suitable for local viewing, without an
   internet connection) in official distribution tarballs under
   https://github.com/openpmix/openpmix/releases.

## Building the documentation locally

The source code for OpenPMIx's docs can be found in the OpenPMIx Git
repository under the `docs` folder.

Developers who clone the OpenPMIx Git repository will not have the
HTML documentation and man pages by default; it must be built.
Instructions for how to build the OpenPMIx documentation can be found
here:
https://docs.openpmix.org/en/latest/developers/prerequisites.html#sphinx-and-therefore-python.


## How to contribute to the PMIx Reference Library

General information about contributing to the PMIx project can be found at the [Contributing to PMIx webpage](https://openpmix.github.io/contribute/).
The instructions below are specifically for opening issues and pull requests against the PMIx Reference Library.

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/openpmix/openpmix/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/openpmix/openpmix/issues/new).


#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. If there is an existing GitHub issue open describing this bug, please include it in the description so we can close it.

* Before submitting, please read the [Contributing to PMIx](https://docs.openpmix.org/en/latest/contributing.html) web pages.  In particular, note that all git commits contributed to PMIx require a Signed-off-by line.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change on the [devel mail list](https://groups.google.com/forum/#!forum/pmix) and start writing code.

* Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.

#### **Do you have questions about the source code?**

* We are working to provide more online info about the PMIx code. Meantime, the [devel mail list](https://groups.google.com/forum/#!forum/pmix) is a good place to post questions about the source code.

Thanks

The PMIx Team


## Security policy

The OpenPMIx security policy can be viewed online at https://docs.openpmix.org/en/latest/security.html.

NOTE: any potential security issue should be reported immediately to us at security@pmix.org
