# +-----------------------------------------------------------------------+
# | pLoader - a Perl photo uploader for Piwigo                            |
# +-----------------------------------------------------------------------+
# | Copyright(C) 2008-2010 Piwigo Team                  http://piwigo.org |
# +-----------------------------------------------------------------------+
# | This program is free software; you can redistribute it and/or modify  |
# | it under the terms of the GNU General Public License as published by  |
# | the Free Software Foundation                                          |
# |                                                                       |
# | This program is distributed in the hope that it will be useful, but   |
# | WITHOUT ANY WARRANTY; without even the implied warranty of            |
# | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      |
# | General Public License for more details.                              |
# |                                                                       |
# | You should have received a copy of the GNU General Public License     |
# | along with this program; if not, write to the Free Software           |
# | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, |
# | USA.                                                                  |
# +-----------------------------------------------------------------------+
package Uploader::GUI::wxGlobalSettings;
use strict;
use Wx qw/
            wxDefaultSize
            wxDefaultPosition
            wxVERTICAL
            wxDEFAULT_DIALOG_STYLE
            wxCAPTION
            wxCLOSE_BOX
            wxMAXIMIZE_BOX
            wxMINIMIZE_BOX
            wxRESIZE_BORDER
            wxALIGN_CENTER
            wxALL
            wxBK_DEFAULT
            wxALIGN_CENTER_VERTICAL
            wxGROW
            wxALIGN_CENTER_VERTICAL
            wxLI_HORIZONTAL
            wxALIGN_BOTTOM
            wxALIGN_CENTER_HORIZONTAL
            wxBITMAP_TYPE_PNG
            wxTheApp
            wxBK_LEFT
            wxHORIZONTAL
        /;
use base qw/Wx::Dialog Uploader::GUI::DlgCommon/;
use Wx::Locale qw/:default/;
use Wx::Event qw/
            EVT_CLOSE
        /;

use Carp;
use Data::Dumper;

sub new {
    my ($this, $params) = @_;

    my $class = ref($this) || $this;


    my $self = $class->SUPER::new(
        undef,
        -1,
        $params->{caption},
        wxDefaultPosition,
        wxDefaultSize,
            wxCAPTION|
            wxCLOSE_BOX|
            wxMAXIMIZE_BOX|
            wxMINIMIZE_BOX|
            wxRESIZE_BORDER|
            wxDEFAULT_DIALOG_STYLE
    );




    $self->{tags} = $params->{tags};
    $self->{orientation} = $params->{orientation}||wxVERTICAL;

    # load controls
    GlobalSetting_ToolBook($self, 1);

    $self->properties(
        $params->{properties}
    );


    $self->{cpane_thumbnail} = $self->FindWindow($main::CPANE_THUMBNAIL);
    $self->{cpane_resize} = $self->FindWindow($main::CPANE_RESIZE);
    $self->{cpane_resize_advanced} = $self->FindWindow($main::CPANE_RESIZE_ADVANCED);
    $self->{cpane_hd} = $self->FindWindow($main::CPANE_HD);
    $self->{cpane_hd_advanced} = $self->FindWindow($main::CPANE_HD_ADVANCED);
    $self->{cpane_watermark} = $self->FindWindow($main::CPANE_WATERMARK);
    $self->{cpane_transfert_advanced} = $self->FindWindow($main::CPANE_TRANSFERT_ADVANCED);
    $self->{gs_close} = $self->FindWindow($main::GS_CLOSE);

    $self->InitLabels();
    $self->InitChoices();
    $self->SetProperties();
    $self->InitHandler();
    $self->_initEventHandlers();

    $self->_DefautPhotoCaption(
        $main::GS_DEFAULT_PHOTO_CAPTION
    );

    if($@){
        Wx::LogMessage("Error during dialogbox initialization");
    }

    # Force layout an paint : awful but works
    $self->{cpane_hd}->Collapse(0);
    $self->{cpane_hd}->Collapse(1);

    $self;    
}



sub _initEventHandlers {
    my ( $self ) = @_;
    
    Wx::Event::EVT_BUTTON( $self, $self->{gs_close}, \&OnClose );
    # Required for GTK
    Wx::Event::EVT_COLLAPSIBLEPANE_CHANGED( $self, $self->{cpane_thumbnail}, \&OnPaneChanged );
    Wx::Event::EVT_COLLAPSIBLEPANE_CHANGED( $self, $self->{cpane_resize}, \&OnPaneChanged );
    Wx::Event::EVT_COLLAPSIBLEPANE_CHANGED( $self, $self->{cpane_resize_advanced}, \&OnPaneChanged );
    Wx::Event::EVT_COLLAPSIBLEPANE_CHANGED( $self, $self->{cpane_hd}, \&OnPaneChanged );
    Wx::Event::EVT_COLLAPSIBLEPANE_CHANGED( $self, $self->{cpane_hd_advanced}, \&OnPaneChanged );
    Wx::Event::EVT_COLLAPSIBLEPANE_CHANGED( $self, $self->{cpane_watermark}, \&OnPaneChanged );
    Wx::Event::EVT_COLLAPSIBLEPANE_CHANGED( $self, $self->{cpane_transfert_advanced}, \&OnPaneChanged );


}


sub OnClose {
    my ( $self, $event ) = @_;
    
    $self->_close;
}

sub _close {
    my ( $self ) = @_;


    $self->Hide;
}


sub OnDefaultPhotoCaption {
    my ( $self, $event ) = @_;
    
    $self->_DefautPhotoCaption(
        $event->GetId
    );

    $event->Skip(1);
}

# Display prefix textfield when needed
sub _DefautPhotoCaption {
    my ( $self, $id ) = @_;

    my $b=0;
    if('CODE' eq ref $self->properties->{$id}->{string_selection}){
        if ( $self->properties->{$id}
            ->{string_selection}->() =~ /caption/i ){
            $b=1;
        }
    }

    map {
        $self->FindWindow($_)->Show($b)
    }(
        $main::PHOTO_CAPTION_PREFIX,
        $main::GS_PHOTO_CAPTION_PREFIX
    );
}

sub OnCreateResized {
    my ( $self, $event ) = @_;
    
    my $id = $event->GetId;
    my $b = 1;
    if('CODE' eq ref $self->properties->{$id}->{selection}){
        $b = !$self->properties->{$id}->{selection}->()
    }

    $self->{cpane_resize}->Collapse($b);

    $event->Skip(1);

}


sub OnHDUpload {
    my ( $self, $event ) = @_;
    

    my $id = $event->GetId;
    my $b = 1;
    if('CODE' eq ref $self->properties->{$id}->{string_selection}){
        if ( $self->properties->{$id}
            ->{string_selection}->() =~ /resized/){
            $b = 0;
        }
    }
    $self->{cpane_hd}->Collapse($b);

    $event->Skip(1);
}

sub OnWatermark {
    my ( $self, $event ) = @_;
    
    my $id = $event->GetId;
    my $b = 1;
    if('CODE' eq ref $self->properties->{$id}->{value}){
        $b = !$self->properties->{$id}->{value}->()
    }

    $self->{cpane_watermark}->Collapse($b);

    $event->Skip(1);
}

sub OnPaneChanged {
    my( $self, $event ) = @_;

    $self->Layout;
    $event->Skip(1);
}


sub GlobalSetting_ToolBook {
    my( $parent ) = $_[0];
    my( $topsizer ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $tbook ) = Wx::Toolbook->new( $parent, $main::ID_NOTEBOOK, wxDefaultPosition, [-1,-1], wxBK_LEFT  );

    my $imgl = Wx::ImageList->new( 16, 16 );

    map {
        $imgl->Add(
            Wx::Bitmap->new( wxTheApp->resource_path($_), wxBITMAP_TYPE_PNG )
        )
    } qw/picture_edit.png pictures.png picture_key.png picture_go.png world.png/;

    $tbook->AssignImageList($imgl);

    my( $item3 ) = Wx::Panel->new( $tbook, -1 );
    &main::GS_photo_properties( $item3, 0 );
    $tbook->AddPage( $item3, gettext("Photo properties"), 0, 0 );

    my( $item4 ) = Wx::Panel->new( $tbook, -1 );
    &main::GS_photo_preparation( $item4, 0 );
    $tbook->AddPage( $item4, gettext("Photo size"), 0, 1 );

    my( $item5 ) = Wx::Panel->new( $tbook, -1 );
    &main::GS_photo_watermark( $item5, 0 );
    $tbook->AddPage( $item5, gettext("Watermark"), 0, 2 );

    my( $item6 ) = Wx::Panel->new( $tbook, -1 );
    &main::GS_photo_transfer( $item6, 0 );
    $tbook->AddPage( $item6, gettext("Transfer"), 0, 3 );

    my( $item7 ) = Wx::Panel->new( $tbook, -1 );
    &main::GS_language( $item7, 0 );
    $tbook->AddPage( $item7, gettext("Language choice"), 0, 4 );


    $topsizer->Add( $tbook, 0, wxALIGN_CENTER|wxALL, 5 );


    my( $item87 ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $item88 ) = Wx::StaticLine->new( $parent, -1, wxDefaultPosition, [20,-1], wxLI_HORIZONTAL );
    $item87->AddWindow( $item88, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item89 ) = Wx::Button->new( $parent, $main::GS_CLOSE, gettext("Close"), wxDefaultPosition, wxDefaultSize, 0 );
    $item87->AddWindow( $item89, 0, wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL|wxALL, 5 );

    $topsizer->Add( $item87, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );


    $_[0]->SetSizerAndFit( $topsizer );



    $topsizer;
}


1;