/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef RATINGWIDGET_H
#define RATINGWIDGET_H

#include <QtGui/QGraphicsWidget>

class QGraphicsSceneMouseEvent;
class QGraphicsSceneHoverEvent;
class QPainter;
class KRatingPainter;

class RatingWidget : public QGraphicsWidget
{
    Q_OBJECT
    public:
        RatingWidget(QGraphicsWidget *parent);
        ~RatingWidget(void);

        void setSpacing(int spacing);
        unsigned int rating(void) const;
        void setRating(unsigned int rating);
        void setMaxRating(unsigned int max);
        void setHalfStepsEnabled(bool enabled);
    // 	void mousePressEvent(QGraphicsSceneMouseEvent* e);
    // 	void hoverMoveEvent(QGraphicsSceneHoverEvent* e);
    // 	void hoverEnterEvent(QGraphicsSceneHoverEvent* e);
    // 	void hoverLeaveEvent(QGraphicsSceneHoverEvent* );
        void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

    signals:
        void ratingChanged(unsigned int rating);

    private:
        KRatingPainter *m_ratingPainter;

        unsigned int currentRating;
        unsigned int hoverRating;

};

#endif
