/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "infomanager.h"

#include <QtGui/QGraphicsWidget>

#include <KDebug>

#include "playercontroller.h"

InfoManager::InfoManager(QObject *parent)
           : QObject(parent)
{
    connect(PlayerController::self(), SIGNAL(metadataChanged(const QVariantMap &)),
            this, SLOT(updateMetadata(const QVariantMap &)));
}

InfoManager::~InfoManager()
{

}

void InfoManager::registerVolumeWidget(QGraphicsWidget *widget)
{
//     connect(PlayerController::self() ,SIGNAL(volumeChanged(const int&)), 
// 	    widget,SIGNAL(setVolume(const int&)));

    connect(widget, SIGNAL(volumeChanged(const int)),
            PlayerController::self(), SLOT(setVolume(const int)));
}

void InfoManager::registerInfoWidget(QGraphicsWidget *widget)
{
    connect(PlayerController::self(), SIGNAL(positionChanged(const int, const int)),
            widget, SLOT(setPosition(const int, const int)));
    connect(this, SIGNAL(updateInfos(const QString &, const QString &, const QString &)),
            widget, SLOT(setInfos(const QString &, const QString &, const QString &)));
    connect(PlayerController::self(), SIGNAL(clear()), widget, SLOT(clear()));
}

void InfoManager::registerButtonsWidget(QGraphicsWidget *widget)
{
    connect(PlayerController::self(), SIGNAL(statusChanged(const int)),
            widget, SLOT(setStatus(const int)));

    connect(widget, SIGNAL(playPausePressed()), PlayerController::self(), SLOT(playPause()));
    connect(widget, SIGNAL(stopPressed()), PlayerController::self(), SLOT(stop()));
    connect(widget, SIGNAL(prevPressed()), PlayerController::self(), SLOT(prev()));
    connect(widget, SIGNAL(nextPressed()), PlayerController::self(), SLOT(next()));
    connect(widget, SIGNAL(showAmarokPressed()), PlayerController::self(), SLOT(showAmarok()));
}

void InfoManager::registerRatingWidget(QGraphicsWidget *widget)
{
    connect(this, SIGNAL(updateRating(const int)), widget, SLOT(setRating(const int)));

//     connect(widget, SIGNAL(ratingChanged(const int&)), 
// 	    PlayerController::self(), SLOT(setRating(const int&)));
}

void InfoManager::registerCoverWidget(QGraphicsWidget *widget)
{
    connect(this, SIGNAL(updateCover(const QString&)), widget, SLOT(setImage(const QString &)));
    connect(PlayerController::self(), SIGNAL(clear()), widget, SLOT(clear()));
}

void InfoManager::registerMeterWidget(QGraphicsWidget *widget)
{
    connect(PlayerController::self() ,SIGNAL(positionChanged(const int, const int)),
            widget, SLOT(setPosition(const int&, const int&)));
    connect(PlayerController::self() ,SIGNAL(clear()),
            widget, SLOT(clear()));

    connect(widget, SIGNAL(valueChanged(const int)), PlayerController::self(), SLOT(seek(const int)));
}

void InfoManager::registerPlaylistWidget(QGraphicsWidget *widget)
{
    connect(PlayerController::self(), SIGNAL(playlistChanged(const QStringList &)),
            widget, SLOT(setPlaylist(const QStringList &)));
}

void InfoManager::updateMetadata(const QVariantMap &metadata)
{
    int i = metadata.value("location").toString().indexOf(":");
    QString mode = metadata.value("location").toString().left(i);

    if (metadata.value("arturl").toString() != QString()) {
        emit updateCover(metadata.value("arturl").toString());
    } else if (mode == QString("lastfm")) {
        emit updateCover("file:///usr/share/apps/amarok/images/lastfm-default-cover.png");
    } else {
        emit updateCover("file:///usr/share/apps/amarok/images/nocover.png");
    }

    emit updateInfos(metadata.value("artist").toString(),
                     metadata.value("album").toString(),
                     metadata.value("title").toString());

    emit updateRating(metadata.value("rating").toInt());
}

#include "infomanager.moc"
