inherit eutils

ECVS_SERVER="cvs.prelude-ids.org:/cvsroot/prelude"
ECVS_MODULE="prelude-lml"
ECVS_BRANCH="${ECVS_MODULE}-`echo ${PV} | sed s:\\\.:-:g`"
ECVS_TOP_DIR="${DISTDIR}/cvs-src/${ECVS_MODULE}"

inherit cvs

S=${WORKDIR}/${ECVS_MODULE}

DESCRIPTION="Prelude-IDS Log Monitoring Lackey"
HOMEPAGE="http://www.prelude-ids.org"
LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~x86"
IUSE="doc"
DEPEND="virtual/glibc
	dev-libs/libprelude-cvs
	!app-admin/prelude-lml
	!dev-libs/libprelude
	dev-libs/libpcre
	doc? ( dev-util/gtk-doc )"

RDEPEND="${DEPEND}"

src_compile() {
	local myconf
	export WANT_AUTOCONF_2_5="1"
	export WANT_AUTOMAKE_1_6="1"
	export MAKEOPTS="" # Doesn't compile if you using make -j

	use doc && myconf="${myconf} --enable-gtk-doc" || myconf="${myconf} --enable-gtk-doc=no"

	aclocal -I /usr/share/aclocal
	autoconf
	autoheader
	libtoolize -c --force --ltdl --automake
	automake --gnu -a -c
	cd libltdl
	mv configure.in configure.in.tmp
	echo "AC_PREREQ(2.50)" > configure.in
	cat configure.in.tmp >> configure.in
	rm -f configure.in.tmp
	aclocal -I /usr/share/aclocal
	autoconf
	autoheader
	libtoolize -c --force --ltdl --automake
	automake --gnu -a -c
	cd ..
	econf ${myconf} || die "econf failed"
	emake || die "emake failed"
}

src_install() {
	make DESTDIR=${D} install || die "make install failed"

	# We skip start/stop scripts with the -cvs verison
	# If you want the scripts then use non -cvs

	#insinto /etc/init.d
	#insopts -m 755
	#newins ${FILESDIR}/gentoo.init prelude-lml
	#insinto /etc/conf.d
	#insopts -m 644
	#newins ${FILESDIR}/gentoo.conf prelude-lml

	into /usr/share/prelude/ruleset
	mv ${D}/etc/prelude-lml/ruleset ${D}/usr/share/prelude/ruleset/lml
	dosym /usr/share/prelude/ruleset/lml /etc/prelude-lml/ruleset
}
