/*	Connect_test

Simply constructs a Database using the default Database.conf
configuration, then a push of a button will Connect or Disconnect.

A Database construction exception is reported to stdout.
Connect/Disconnect exceptions are reported in a dialog box.

CVS ID: Connect_test.java,v 1.3 2012/04/16 06:08:57 castalia Exp


Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import PIRL.Database.*;
import PIRL.Viewers.*;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JButton;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Dimension;


public class Connect_test
{

private static Database
	The_Database;
private static boolean
	Connected = false;
private static JButton
	Connection_Button;

public static void main (String[] arguments) 
{
final JFrame
	frame = new JFrame ("Database Connection Test");
frame.addWindowListener (new WindowAdapter ()
	{public void windowClosing (WindowEvent e) {System.exit (0);}});

JPanel
	content = new JPanel ();
frame.setContentPane (content);

Connection_Button = new JButton ("Connect");
Connection_Button.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent e)
	{
	Connection_Action ();
	}});
content.add (Connection_Button);

//	Create a new Database.
try {The_Database = new Database ();}
catch (Database_Exception exception)
	{System.out.println ("Unable construct a Database object.\n"
		+ exception.getMessage ());}

content.setPreferredSize (new Dimension (150, 50));
frame.pack ();
frame.setVisible (true);
}

private static void Connection_Action ()
{
try
	{
	if (Connected)
		{
		The_Database.Disconnect ();
		Connection_Button.setText ("Connect");
		Connected = false;
		}
	else
		{
		The_Database.Connect ();
		Connection_Button.setText ("Disconnect");
		Connected = true;
		}
	}
catch (Exception exception)
	{
	Dialog_Box.Error ("Unable to " + (Connected ? "dis" : "") + "connect\n\n"
		+ exception.getMessage ());
	}
}

}
