.\" -*- coding: us-ascii -*-
.if \n(.g .ds T< \\FC
.if \n(.g .ds T> \\F[\n[.fam]]
.de URL
\\$2 \(la\\$1\(ra\\$3
..
.if \n(.g .mso www.tmac
.TH pg_result n "March 2018" "" "PostgreSQL Tcl Interface Documentation"
.SH NAME
pg_result \- get information about a command result
.SH SYNOPSIS
.nf

pg_result \*(T<resultHandle\*(T> \*(T<resultOption\*(T>
.fi
.SH DESCRIPTION
\*(T<\fBpg_result\fR\*(T> returns information about a command
result created by a prior \*(T<\fBpg_exec\fR\*(T>.
.PP
You can keep a command result around for as long as you need it,
but when you are done with it, be sure to free it by executing
\*(T<\fBpg_result \-clear\fR\*(T>. Otherwise, you have a
memory leak, and pgtcl will eventually start
complaining that you have created too many command result objects.
.SH ARGUMENTS
.TP 
\*(T<resultHandle\*(T>
The handle of the command result.
.TP 
\*(T<resultOption\*(T>
One of the following options, specifying which piece of result
information to return:
.RS 
.TP 
\*(T<\fB\-status\fR\*(T>
The status of the result.
.TP 
\*(T<\fB\-error\fR\*(T> [\*(T<diagCode\*(T>]
The error message, if the status indicates an error,
otherwise an empty string.

\*(T<diagCode\*(T>, if specified, requests data
for a specific diagnostic code:
.RS 
.TP 
\*(T<\fBseverity\fR\*(T>
The severity; the field contents are \*(T<ERROR\*(T>,
\*(T<FATAL\*(T>, or \*(T<PANIC\*(T>, in
an error message, or \*(T<WARNING\*(T>,
\*(T<NOTICE\*(T>, \*(T<DEBUG\*(T>,
\*(T<INFO\*(T>, or \*(T<LOG\*(T>,
in a notice message, or a localized translation of one of
these.
.TP 
\*(T<\fBsqlstate\fR\*(T>
The \*(T<SQLSTATE\*(T> code for the error.
(See PostgreSQL manual Appendix A).
.TP 
\*(T<\fBprimary\fR\*(T>
The primary human-readable error message (typically one line).
.TP 
\*(T<\fBdetail\fR\*(T>
An optional secondary error message carrying more detail
abhout the problem, which may run to multiple lines.
.TP 
\*(T<\fBhint\fR\*(T>
An optional suggestion about what to do about the problem.
This is intended to differ from detail in that it offers
advice (potentially inappropriate) rather than hard facts.

The result may run to multiple lines.
.TP 
\*(T<\fBposition\fR\*(T>
A string containing a decimal integer indicating an error 
cursor position as an index into the original statement string.

The first character has index \*(T<1\*(T>, and 
positions are measured in characters not bytes. 
.TP 
\*(T<\fBinternal_position\fR\*(T>
This is the same as "position", but it is used when the cursor
position refers to an internally generated command rather than
the one submitted by the client.

The first character has index \*(T<1\*(T>, and 
positions are measured in characters not bytes. 
.TP 
\*(T<\fBinternal_query\fR\*(T>
This is the text of a failed internally generated command.
This could be, for example, a SQL query issued by a
PL/pgSQL function.
.TP 
\*(T<\fBcontext\fR\*(T>
An indication of the context in which the error occurred. 
Presently this includes a call stack traceback of active PL 
functions. The trace is one entry per line, most recent first. 
.TP 
\*(T<\fBfile\fR\*(T>
The filename of the source code location where the error
was reported.
.TP 
\*(T<\fBline\fR\*(T>
The line number of the source code location where the error
was reported.
.TP 
\*(T<\fBfunction\fR\*(T>
The name of the source code function reporting the error.
.RE
.TP 
\*(T<\fB\-foreach \fR\*(T>\*(T<\fBarrayName\fR\*(T>\*(T<\fB \fR\*(T>\*(T<\fBtclCode\fR\*(T>
Iterates through each row of the result, filling
\*(T<arrayName\*(T> with the columns and their values and
executing \*(T<tclCode\*(T> for each row in turn.
Null columns will be not be present in the array.
.TP 
\*(T<\fB\-conn\fR\*(T>
The connection that produced the result.
.TP 
\*(T<\fB\-oid\fR\*(T>
If the command was an \fBINSERT\fR, the OID of
the inserted row, otherwise 0.
.TP 
\*(T<\fB\-numTuples\fR\*(T>
The number of rows (tuples) returned by the query.
.TP 
\*(T<\fB\-cmdTuples\fR\*(T>
The number of rows (tuples) affected by the command.
(This is similar to \*(T<\fB\-numTuples\fR\*(T> but
relevant to \fBINSERT\fR and
\fBUPDATE\fR commands.)
.TP 
\*(T<\fB\-numAttrs\fR\*(T>
The number of columns (attributes) in each row.
.TP 
\*(T<\fB\-assign \fR\*(T>\*(T<\fBarrayName\fR\*(T>
Assign the results to an array, using subscripts of the form
\*(T<(rowNumber, columnName)\*(T>.
.TP 
\*(T<\fB\-foreach \fR\*(T>\*(T<\fBarrayName\fR\*(T>\*(T<\fB \fR\*(T>\*(T<\fBcode\fR\*(T>
For each resulting row assigns the results to the named array, using
subscripts matching the column names, then executes the code body.
.TP 
\*(T<\fB\-assignbyidx \fR\*(T>\*(T<\fBarrayName\fR\*(T>\*(T<\fB \fR\*(T>\*(T<\fB[appendstr]\fR\*(T>
Assign the results to an array using the values of the
first column and the names of the remaining column as keys.
If \*(T<appendstr\*(T> is given then it is appended to
each key. In short, all but the first column of each row
are stored into the array, using subscripts of the form
\*(T<(firstColumnValue, columnNameAppendStr)\*(T>.
.TP 
\*(T<\fB\-getTuple \fR\*(T>\*(T<\fBrowNumber\fR\*(T>
Returns the columns of the indicated row in a list. Row
numbers start at zero.
.TP 
\*(T<\fB\-tupleArray \fR\*(T>\*(T<\fBrowNumber\fR\*(T>\*(T<\fB \fR\*(T>\*(T<\fBarrayName\fR\*(T>
Stores the columns of the row in array
\*(T<arrayName\*(T>, indexed by column names.
Row numbers start at zero. If a field's value is null,
sets an empty string or the default string, if a default
string has been defined.
.TP 
\*(T<\fB\-tupleArrayWithoutNulls \fR\*(T>\*(T<\fBrowNumber\fR\*(T>\*(T<\fB \fR\*(T>\*(T<\fBarrayName\fR\*(T>
Stores the columns of the row in array
\*(T<arrayName\*(T>, indexed by column names.
Row numbers start at zero. If a field's value is null,
unsets the column from the array.
.TP 
\*(T<\fB\-attributes\fR\*(T>
Returns a list of the names of the columns in the result.
.TP 
\*(T<\fB\-lAttributes\fR\*(T>
Returns a list of sublists, \*(T<{name typeOid
typeSize}\*(T> for each column.
.TP 
\*(T<\fB\-list\fR\*(T>
Returns one list containing all the data
returned by the query.
.TP 
\*(T<\fB\-llist\fR\*(T>
Returns a list of lists, where each embedded list represents
a tuple in the result.
.TP 
\*(T<\fB\-dict\fR\*(T>
Returns a dict object with the results. This needs to have dictionary
support built into Tcl (Tcl 8.5), and is experimental right now, since 
Tcl 8.5 has not been release yet, and the API could change. In
order to enable this, you need to add \*(T<\-DHAVE_TCL_NEWDICTOBJ
\*(T>to the Makefile in the \*(T<DEFS\*(T> variable.
.TP 
\*(T<\fB\-null_value_string \fR\*(T>\*(T<\fB[string]\fR\*(T>
Defines or retrieves the string that will be returned for null values in query results. Defaults to whatever was set by \*(T<\fBpg_null_value_string\fR\*(T> but can be set here and, in this case, affects only this query result.
.TP 
\*(T<\fB\-clear\fR\*(T>
Clear the command result object.
.RE
.SH "RETURN VALUE"
The result depends on the selected option, as described above.
