/*PGR-GNU*****************************************************************
File: bdDijkstra_driver.cpp

Generated with Template by:
Copyright (c) 2015 pgRouting developers
Mail: project@pgrouting.org

Function's developer:
Copyright (c) 2016 Celia Virginia Vergara Castillo
Mail: vicky_vergara@hotmail.com

------

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 ********************************************************************PGR-GNU*/

#include "drivers/bdDijkstra/bdDijkstra_driver.h"

#include <sstream>
#include <deque>
#include <vector>
#include <algorithm>

#include "bdDijkstra/pgr_bdDijkstra.hpp"


#include "cpp_common/pgr_alloc.hpp"
#include "cpp_common/pgr_assert.h"
#include "cpp_common/pgr_base_graph.hpp"

#include "c_types/ii_t_rt.h"



namespace {

template < class G >
std::deque<pgrouting::Path>
pgr_bdDijkstra(
        G &graph,
        std::vector < II_t_rt > &combinations,
        std::vector < int64_t > sources,
        std::vector < int64_t > targets,

        std::ostream &log,
        bool only_cost) {
    using pgrouting::Path;

    pgrouting::bidirectional::Pgr_bdDijkstra<G> fn_bdDijkstra(graph);
    std::deque<Path> paths;

    if (combinations.empty()) {
        std::sort(sources.begin(), sources.end());
        sources.erase(
                std::unique(sources.begin(), sources.end()),
                sources.end());

        std::sort(targets.begin(), targets.end());
        targets.erase(
                std::unique(targets.begin(), targets.end()),
                targets.end());

        for (const auto source : sources) {
            for (const auto target : targets) {
                fn_bdDijkstra.clear();

                if (!graph.has_vertex(source)
                        || !graph.has_vertex(target)) {
                    paths.push_back(Path(source, target));
                    continue;
                }

                paths.push_back(fn_bdDijkstra.pgr_bdDijkstra(
                        graph.get_V(source), graph.get_V(target), only_cost));
            }
        }

    } else {
        std::sort(combinations.begin(), combinations.end(),
                [](const II_t_rt &lhs, const II_t_rt &rhs)->bool {
                    return lhs.d2.target < rhs.d2.target;
                });
        std::stable_sort(combinations.begin(), combinations.end(),
                [](const II_t_rt &lhs, const II_t_rt &rhs)->bool {
                    return lhs.d1.source < rhs.d1.source;
                });

        II_t_rt previousCombination {{0}, {0}};

        for (const II_t_rt &comb : combinations) {
            fn_bdDijkstra.clear();
            if (comb.d1.source == previousCombination.d1.source &&
                    comb.d2.target == previousCombination.d2.target) {
                continue;
            }

            if (!graph.has_vertex(comb.d1.source)
                    || !graph.has_vertex(comb.d2.target)) {
                paths.push_back(Path(comb.d1.source, comb.d2.target));
                continue;
            }

            paths.push_back(fn_bdDijkstra.pgr_bdDijkstra(
                    graph.get_V(comb.d1.source), graph.get_V(comb.d2.target), only_cost));

            previousCombination = comb;
        }
    }

    log << fn_bdDijkstra.log();

    return paths;
}

}  // namespace

void
do_pgr_bdDijkstra(
        Edge_t  *data_edges,
        size_t total_edges,
        II_t_rt *combinations,
        size_t total_combinations,
        int64_t  *start_vidsArr,
        size_t size_start_vidsArr,
        int64_t  *end_vidsArr,
        size_t size_end_vidsArr,

        bool directed,
        bool only_cost,

        Path_rt **return_tuples,
        size_t *return_count,
        char **log_msg,
        char **notice_msg,
        char **err_msg) {
    using pgrouting::Path;
    using pgrouting::pgr_msg;
    using pgrouting::pgr_free;
    using pgrouting::pgr_alloc;

    std::ostringstream log;
    std::ostringstream err;
    std::ostringstream notice;
    try {
        pgassert(total_edges != 0);
        pgassert(!(*log_msg));
        pgassert(!(*notice_msg));
        pgassert(!(*err_msg));
        pgassert(!(*return_tuples));
        pgassert(*return_count == 0);

        log << "Inserting vertices into a c++ vector structure";
        std::vector<int64_t>
            start_vertices(start_vidsArr, start_vidsArr + size_start_vidsArr);
        std::vector< int64_t >
            end_vertices(end_vidsArr, end_vidsArr + size_end_vidsArr);
        std::vector< II_t_rt >
            combinations_vector(combinations, combinations + total_combinations);

        graphType gType = directed? DIRECTED: UNDIRECTED;

        std::deque<Path> paths;

        log << "starting process\n";
        if (directed) {
            log << "Working with directed Graph\n";
            pgrouting::DirectedGraph digraph(gType);
            digraph.insert_edges(data_edges, total_edges);
            paths = pgr_bdDijkstra(digraph,
                    combinations_vector,
                    start_vertices,
                    end_vertices,
                    log,
                    only_cost);
        } else {
            log << "Working with Undirected Graph\n";
            pgrouting::UndirectedGraph undigraph(gType);
            undigraph.insert_edges(data_edges, total_edges);
            paths = pgr_bdDijkstra(
                    undigraph,
                    combinations_vector,
                    start_vertices,
                    end_vertices,
                    log,
                    only_cost);
        }

        size_t count(0);
        count = count_tuples(paths);

        if (count == 0) {
            (*return_tuples) = NULL;
            (*return_count) = 0;
            notice <<
                "No paths found";
            *log_msg = pgr_msg(notice.str().c_str());
            return;
        }

        (*return_tuples) = pgr_alloc(count, (*return_tuples));
        log << "\nConverting a set of paths into the tuples";
        (*return_count) = (collapse_paths(return_tuples, paths));

        pgassert(*err_msg == NULL);
        *log_msg = log.str().empty()?
            *log_msg :
            pgr_msg(log.str().c_str());
        *notice_msg = notice.str().empty()?
            *notice_msg :
            pgr_msg(notice.str().c_str());
    } catch (AssertFailedException &except) {
        (*return_tuples) = pgr_free(*return_tuples);
        (*return_count) = 0;
        err << except.what();
        *err_msg = pgr_msg(err.str().c_str());
        *log_msg = pgr_msg(log.str().c_str());
    } catch (std::exception &except) {
        (*return_tuples) = pgr_free(*return_tuples);
        (*return_count) = 0;
        err << except.what();
        *err_msg = pgr_msg(err.str().c_str());
        *log_msg = pgr_msg(log.str().c_str());
    } catch(...) {
        (*return_tuples) = pgr_free(*return_tuples);
        (*return_count) = 0;
        err << "Caught unknown exception!";
        *err_msg = pgr_msg(err.str().c_str());
        *log_msg = pgr_msg(log.str().c_str());
    }
}
