/* pdf.c generated by valac 0.16.0, the Vala compiler
 * generated from pdf.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <poppler.h>
#include <cairo.h>


#define PDFPC_RENDERER_TYPE_BASE (pdfpc_renderer_base_get_type ())
#define PDFPC_RENDERER_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_BASE, pdfpcRendererBase))
#define PDFPC_RENDERER_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_BASE, pdfpcRendererBaseClass))
#define PDFPC_RENDERER_IS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_BASE))
#define PDFPC_RENDERER_IS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_BASE))
#define PDFPC_RENDERER_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_BASE, pdfpcRendererBaseClass))

typedef struct _pdfpcRendererBase pdfpcRendererBase;
typedef struct _pdfpcRendererBaseClass pdfpcRendererBaseClass;
typedef struct _pdfpcRendererBasePrivate pdfpcRendererBasePrivate;

#define PDFPC_METADATA_TYPE_BASE (pdfpc_metadata_base_get_type ())
#define PDFPC_METADATA_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_METADATA_TYPE_BASE, pdfpcMetadataBase))
#define PDFPC_METADATA_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_METADATA_TYPE_BASE, pdfpcMetadataBaseClass))
#define PDFPC_METADATA_IS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_METADATA_TYPE_BASE))
#define PDFPC_METADATA_IS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_METADATA_TYPE_BASE))
#define PDFPC_METADATA_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_METADATA_TYPE_BASE, pdfpcMetadataBaseClass))

typedef struct _pdfpcMetadataBase pdfpcMetadataBase;
typedef struct _pdfpcMetadataBaseClass pdfpcMetadataBaseClass;

#define PDFPC_RENDERER_TYPE_CACHING (pdfpc_renderer_caching_get_type ())
#define PDFPC_RENDERER_CACHING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_CACHING, pdfpcRendererCaching))
#define PDFPC_RENDERER_IS_CACHING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_CACHING))
#define PDFPC_RENDERER_CACHING_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PDFPC_RENDERER_TYPE_CACHING, pdfpcRendererCachingIface))

typedef struct _pdfpcRendererCaching pdfpcRendererCaching;
typedef struct _pdfpcRendererCachingIface pdfpcRendererCachingIface;

#define PDFPC_RENDERER_CACHE_TYPE_BASE (pdfpc_renderer_cache_base_get_type ())
#define PDFPC_RENDERER_CACHE_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_CACHE_TYPE_BASE, pdfpcRendererCacheBase))
#define PDFPC_RENDERER_CACHE_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_CACHE_TYPE_BASE, pdfpcRendererCacheBaseClass))
#define PDFPC_RENDERER_CACHE_IS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_CACHE_TYPE_BASE))
#define PDFPC_RENDERER_CACHE_IS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_CACHE_TYPE_BASE))
#define PDFPC_RENDERER_CACHE_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_CACHE_TYPE_BASE, pdfpcRendererCacheBaseClass))

typedef struct _pdfpcRendererCacheBase pdfpcRendererCacheBase;
typedef struct _pdfpcRendererCacheBaseClass pdfpcRendererCacheBaseClass;

#define PDFPC_RENDERER_TYPE_PDF (pdfpc_renderer_pdf_get_type ())
#define PDFPC_RENDERER_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdf))
#define PDFPC_RENDERER_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdfClass))
#define PDFPC_RENDERER_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_PDF))
#define PDFPC_RENDERER_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_PDF))
#define PDFPC_RENDERER_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdfClass))

typedef struct _pdfpcRendererPdf pdfpcRendererPdf;
typedef struct _pdfpcRendererPdfClass pdfpcRendererPdfClass;
typedef struct _pdfpcRendererPdfPrivate pdfpcRendererPdfPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PDFPC_METADATA_TYPE_PDF (pdfpc_metadata_pdf_get_type ())
#define PDFPC_METADATA_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdf))
#define PDFPC_METADATA_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))
#define PDFPC_METADATA_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))

typedef struct _pdfpcMetadataPdf pdfpcMetadataPdf;
typedef struct _pdfpcMetadataPdfClass pdfpcMetadataPdfClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

typedef enum  {
	PDFPC_RENDERER_RENDER_ERROR_SLIDE_DOES_NOT_EXIST
} pdfpcRendererRenderError;
#define PDFPC_RENDERER_RENDER_ERROR pdfpc_renderer_render_error_quark ()
struct _pdfpcRendererBase {
	GObject parent_instance;
	pdfpcRendererBasePrivate * priv;
	pdfpcMetadataBase* metadata;
	gint width;
	gint height;
};

struct _pdfpcRendererBaseClass {
	GObjectClass parent_class;
	GdkPixmap* (*render_to_pixmap) (pdfpcRendererBase* self, gint slide_number, GError** error);
	GdkPixmap* (*fade_to_black) (pdfpcRendererBase* self);
};

struct _pdfpcRendererCachingIface {
	GTypeInterface parent_iface;
	void (*set_cache) (pdfpcRendererCaching* self, pdfpcRendererCacheBase* cache);
	pdfpcRendererCacheBase* (*get_cache) (pdfpcRendererCaching* self);
};

struct _pdfpcRendererPdf {
	pdfpcRendererBase parent_instance;
	pdfpcRendererPdfPrivate * priv;
	gdouble scaling_factor;
	pdfpcRendererCacheBase* cache;
};

struct _pdfpcRendererPdfClass {
	pdfpcRendererBaseClass parent_class;
};


static gpointer pdfpc_renderer_pdf_parent_class = NULL;
extern GMutex* pdfpc_mutex_locks_poppler;
static pdfpcRendererCachingIface* pdfpc_renderer_pdf_pdfpc_renderer_caching_parent_iface = NULL;

GType pdfpc_renderer_base_get_type (void) G_GNUC_CONST;
GQuark pdfpc_renderer_render_error_quark (void);
GType pdfpc_metadata_base_get_type (void) G_GNUC_CONST;
GType pdfpc_renderer_cache_base_get_type (void) G_GNUC_CONST;
GType pdfpc_renderer_caching_get_type (void) G_GNUC_CONST;
GType pdfpc_renderer_pdf_get_type (void) G_GNUC_CONST;
enum  {
	PDFPC_RENDERER_PDF_DUMMY_PROPERTY
};
GType pdfpc_metadata_pdf_get_type (void) G_GNUC_CONST;
pdfpcRendererPdf* pdfpc_renderer_pdf_new (pdfpcMetadataPdf* metadata, gint width, gint height);
pdfpcRendererPdf* pdfpc_renderer_pdf_construct (GType object_type, pdfpcMetadataPdf* metadata, gint width, gint height);
pdfpcRendererBase* pdfpc_renderer_base_construct (GType object_type, pdfpcMetadataBase* metadata, gint width, gint height);
gdouble pdfpc_metadata_pdf_get_page_width (pdfpcMetadataPdf* self);
gdouble pdfpc_metadata_pdf_get_page_height (pdfpcMetadataPdf* self);
static void pdfpc_renderer_pdf_real_set_cache (pdfpcRendererCaching* base, pdfpcRendererCacheBase* cache);
static pdfpcRendererCacheBase* pdfpc_renderer_pdf_real_get_cache (pdfpcRendererCaching* base);
static GdkPixmap* pdfpc_renderer_pdf_real_render_to_pixmap (pdfpcRendererBase* base, gint slide_number, GError** error);
guint pdfpc_metadata_base_get_slide_count (pdfpcMetadataBase* self);
GdkPixmap* pdfpc_renderer_cache_base_retrieve (pdfpcRendererCacheBase* self, guint index);
PopplerDocument* pdfpc_metadata_pdf_get_document (pdfpcMetadataPdf* self);
void pdfpc_renderer_cache_base_store (pdfpcRendererCacheBase* self, guint index, GdkPixmap* pixmap);
static GdkPixmap* pdfpc_renderer_pdf_real_fade_to_black (pdfpcRendererBase* base);
static void pdfpc_renderer_pdf_finalize (GObject* obj);


/**
         * Base constructor taking a pdf metadata object as well as the desired
         * render width and height as parameters.
         *
         * The pdf will always be rendered to fill up all available space. If
         * the proportions of the rendersize do not fit the proportions of the
         * pdf document the renderspace is filled up completely cutting of a
         * part of the pdf document.
         */
pdfpcRendererPdf* pdfpc_renderer_pdf_construct (GType object_type, pdfpcMetadataPdf* metadata, gint width, gint height) {
	pdfpcRendererPdf * self = NULL;
	pdfpcMetadataPdf* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	pdfpcMetadataPdf* _tmp4_;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_;
	pdfpcMetadataPdf* _tmp7_;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = metadata;
	_tmp1_ = width;
	_tmp2_ = height;
	self = (pdfpcRendererPdf*) pdfpc_renderer_base_construct (object_type, (pdfpcMetadataBase*) _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = width;
	_tmp4_ = metadata;
	_tmp5_ = pdfpc_metadata_pdf_get_page_width (_tmp4_);
	_tmp6_ = height;
	_tmp7_ = metadata;
	_tmp8_ = pdfpc_metadata_pdf_get_page_height (_tmp7_);
	_tmp9_ = fmax (_tmp3_ / _tmp5_, _tmp6_ / _tmp8_);
	self->scaling_factor = _tmp9_;
	return self;
}


pdfpcRendererPdf* pdfpc_renderer_pdf_new (pdfpcMetadataPdf* metadata, gint width, gint height) {
	return pdfpc_renderer_pdf_construct (PDFPC_RENDERER_TYPE_PDF, metadata, width, height);
}


/**
         * Set cache store to use
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void pdfpc_renderer_pdf_real_set_cache (pdfpcRendererCaching* base, pdfpcRendererCacheBase* cache) {
	pdfpcRendererPdf * self;
	pdfpcRendererCacheBase* _tmp0_;
	pdfpcRendererCacheBase* _tmp1_;
	self = (pdfpcRendererPdf*) base;
	g_return_if_fail (cache != NULL);
	_tmp0_ = cache;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->cache);
	self->cache = _tmp1_;
}


/**
         * Retrieve the currently used cache engine
         */
static pdfpcRendererCacheBase* pdfpc_renderer_pdf_real_get_cache (pdfpcRendererCaching* base) {
	pdfpcRendererPdf * self;
	pdfpcRendererCacheBase* result = NULL;
	pdfpcRendererCacheBase* _tmp0_;
	pdfpcRendererCacheBase* _tmp1_;
	self = (pdfpcRendererPdf*) base;
	_tmp0_ = self->cache;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
         * Render the given slide_number to a Gdk.Pixmap and return it.
         *
         * If the requested slide is not available an
         * RenderError.SLIDE_DOES_NOT_EXIST error is thrown.
         */
static GdkPixmap* pdfpc_renderer_pdf_real_render_to_pixmap (pdfpcRendererBase* base, gint slide_number, GError** error) {
	pdfpcRendererPdf * self;
	GdkPixmap* result = NULL;
	pdfpcMetadataBase* _tmp0_;
	pdfpcMetadataPdf* _tmp1_;
	pdfpcMetadataPdf* metadata;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gboolean _tmp7_;
	pdfpcRendererCacheBase* _tmp10_;
	GMutex* _tmp15_;
	pdfpcMetadataPdf* _tmp16_;
	PopplerDocument* _tmp17_ = NULL;
	PopplerDocument* _tmp18_;
	gint _tmp19_;
	PopplerPage* _tmp20_ = NULL;
	PopplerPage* _tmp21_;
	PopplerPage* page;
	GMutex* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GdkPixmap* _tmp25_;
	GdkPixmap* pixmap;
	GdkPixmap* _tmp26_;
	cairo_t* _tmp27_ = NULL;
	cairo_t* cr;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	GMutex* _tmp36_;
	PopplerPage* _tmp37_;
	cairo_t* _tmp38_;
	GMutex* _tmp39_;
	pdfpcRendererCacheBase* _tmp40_;
	GError * _inner_error_ = NULL;
	self = (pdfpcRendererPdf*) base;
	_tmp0_ = ((pdfpcRendererBase*) self)->metadata;
	_tmp1_ = _g_object_ref0 (PDFPC_METADATA_IS_PDF (_tmp0_) ? ((pdfpcMetadataPdf*) _tmp0_) : NULL);
	metadata = _tmp1_;
	_tmp3_ = slide_number;
	if (_tmp3_ < 0) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp4_;
		pdfpcMetadataPdf* _tmp5_;
		guint _tmp6_ = 0U;
		_tmp4_ = slide_number;
		_tmp5_ = metadata;
		_tmp6_ = pdfpc_metadata_base_get_slide_count ((pdfpcMetadataBase*) _tmp5_);
		_tmp2_ = ((guint) _tmp4_) >= _tmp6_;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gint _tmp8_;
		GError* _tmp9_;
		_tmp8_ = slide_number;
		_tmp9_ = g_error_new (PDFPC_RENDERER_RENDER_ERROR, PDFPC_RENDERER_RENDER_ERROR_SLIDE_DOES_NOT_EXIST, "The requested slide '%i' does not exist.", _tmp8_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == PDFPC_RENDERER_RENDER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (metadata);
			return NULL;
		} else {
			_g_object_unref0 (metadata);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = self->cache;
	if (_tmp10_ != NULL) {
		GdkPixmap* cache_content = NULL;
		pdfpcRendererCacheBase* _tmp11_;
		gint _tmp12_;
		GdkPixmap* _tmp13_ = NULL;
		GdkPixmap* _tmp14_;
		_tmp11_ = self->cache;
		_tmp12_ = slide_number;
		_tmp13_ = pdfpc_renderer_cache_base_retrieve (_tmp11_, (guint) _tmp12_);
		_g_object_unref0 (cache_content);
		cache_content = _tmp13_;
		_tmp14_ = cache_content;
		if (_tmp14_ != NULL) {
			result = cache_content;
			_g_object_unref0 (metadata);
			return result;
		}
		_g_object_unref0 (cache_content);
	}
	_tmp15_ = pdfpc_mutex_locks_poppler;
	g_mutex_lock (_tmp15_);
	_tmp16_ = metadata;
	_tmp17_ = pdfpc_metadata_pdf_get_document (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = slide_number;
	_tmp20_ = poppler_document_get_page (_tmp18_, _tmp19_);
	_tmp21_ = _tmp20_;
	_g_object_unref0 (_tmp18_);
	page = _tmp21_;
	_tmp22_ = pdfpc_mutex_locks_poppler;
	g_mutex_unlock (_tmp22_);
	_tmp23_ = ((pdfpcRendererBase*) self)->width;
	_tmp24_ = ((pdfpcRendererBase*) self)->height;
	_tmp25_ = gdk_pixmap_new (NULL, _tmp23_, _tmp24_, 24);
	pixmap = _tmp25_;
	_tmp26_ = pixmap;
	_tmp27_ = gdk_cairo_create ((GdkDrawable*) _tmp26_);
	cr = _tmp27_;
	_tmp28_ = cr;
	cairo_set_source_rgb (_tmp28_, (gdouble) 255, (gdouble) 255, (gdouble) 255);
	_tmp29_ = cr;
	_tmp30_ = ((pdfpcRendererBase*) self)->width;
	_tmp31_ = ((pdfpcRendererBase*) self)->height;
	cairo_rectangle (_tmp29_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp30_, (gdouble) _tmp31_);
	_tmp32_ = cr;
	cairo_fill (_tmp32_);
	_tmp33_ = cr;
	_tmp34_ = self->scaling_factor;
	_tmp35_ = self->scaling_factor;
	cairo_scale (_tmp33_, _tmp34_, _tmp35_);
	_tmp36_ = pdfpc_mutex_locks_poppler;
	g_mutex_lock (_tmp36_);
	_tmp37_ = page;
	_tmp38_ = cr;
	poppler_page_render (_tmp37_, (cairo_t*) _tmp38_);
	_tmp39_ = pdfpc_mutex_locks_poppler;
	g_mutex_unlock (_tmp39_);
	_tmp40_ = self->cache;
	if (_tmp40_ != NULL) {
		pdfpcRendererCacheBase* _tmp41_;
		gint _tmp42_;
		GdkPixmap* _tmp43_;
		_tmp41_ = self->cache;
		_tmp42_ = slide_number;
		_tmp43_ = pixmap;
		pdfpc_renderer_cache_base_store (_tmp41_, (guint) _tmp42_, _tmp43_);
	}
	result = pixmap;
	_cairo_destroy0 (cr);
	_g_object_unref0 (page);
	_g_object_unref0 (metadata);
	return result;
}


static GdkPixmap* pdfpc_renderer_pdf_real_fade_to_black (pdfpcRendererBase* base) {
	pdfpcRendererPdf * self;
	GdkPixmap* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GdkPixmap* _tmp2_;
	GdkPixmap* pixmap;
	cairo_t* _tmp3_ = NULL;
	cairo_t* cr;
	gint _tmp4_;
	gint _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	self = (pdfpcRendererPdf*) base;
	_tmp0_ = ((pdfpcRendererBase*) self)->width;
	_tmp1_ = ((pdfpcRendererBase*) self)->height;
	_tmp2_ = gdk_pixmap_new (NULL, _tmp0_, _tmp1_, 24);
	pixmap = _tmp2_;
	_tmp3_ = gdk_cairo_create ((GdkDrawable*) pixmap);
	cr = _tmp3_;
	cairo_set_source_rgb (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp4_ = ((pdfpcRendererBase*) self)->width;
	_tmp5_ = ((pdfpcRendererBase*) self)->height;
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) _tmp4_, (gdouble) _tmp5_);
	cairo_fill (cr);
	_tmp6_ = self->scaling_factor;
	_tmp7_ = self->scaling_factor;
	cairo_scale (cr, _tmp6_, _tmp7_);
	result = pixmap;
	_cairo_destroy0 (cr);
	return result;
}


static void pdfpc_renderer_pdf_class_init (pdfpcRendererPdfClass * klass) {
	pdfpc_renderer_pdf_parent_class = g_type_class_peek_parent (klass);
	PDFPC_RENDERER_BASE_CLASS (klass)->render_to_pixmap = pdfpc_renderer_pdf_real_render_to_pixmap;
	PDFPC_RENDERER_BASE_CLASS (klass)->fade_to_black = pdfpc_renderer_pdf_real_fade_to_black;
	G_OBJECT_CLASS (klass)->finalize = pdfpc_renderer_pdf_finalize;
}


static void pdfpc_renderer_pdf_pdfpc_renderer_caching_interface_init (pdfpcRendererCachingIface * iface) {
	pdfpc_renderer_pdf_pdfpc_renderer_caching_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_cache = (void (*)(pdfpcRendererCaching*, pdfpcRendererCacheBase*)) pdfpc_renderer_pdf_real_set_cache;
	iface->get_cache = (pdfpcRendererCacheBase* (*)(pdfpcRendererCaching*)) pdfpc_renderer_pdf_real_get_cache;
}


static void pdfpc_renderer_pdf_instance_init (pdfpcRendererPdf * self) {
	self->cache = NULL;
}


static void pdfpc_renderer_pdf_finalize (GObject* obj) {
	pdfpcRendererPdf * self;
	self = PDFPC_RENDERER_PDF (obj);
	_g_object_unref0 (self->cache);
	G_OBJECT_CLASS (pdfpc_renderer_pdf_parent_class)->finalize (obj);
}


/**
     * Pdf slide renderer
     */
GType pdfpc_renderer_pdf_get_type (void) {
	static volatile gsize pdfpc_renderer_pdf_type_id__volatile = 0;
	if (g_once_init_enter (&pdfpc_renderer_pdf_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (pdfpcRendererPdfClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_renderer_pdf_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcRendererPdf), 0, (GInstanceInitFunc) pdfpc_renderer_pdf_instance_init, NULL };
		static const GInterfaceInfo pdfpc_renderer_caching_info = { (GInterfaceInitFunc) pdfpc_renderer_pdf_pdfpc_renderer_caching_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType pdfpc_renderer_pdf_type_id;
		pdfpc_renderer_pdf_type_id = g_type_register_static (PDFPC_RENDERER_TYPE_BASE, "pdfpcRendererPdf", &g_define_type_info, 0);
		g_type_add_interface_static (pdfpc_renderer_pdf_type_id, PDFPC_RENDERER_TYPE_CACHING, &pdfpc_renderer_caching_info);
		g_once_init_leave (&pdfpc_renderer_pdf_type_id__volatile, pdfpc_renderer_pdf_type_id);
	}
	return pdfpc_renderer_pdf_type_id__volatile;
}



