// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AVTMESHMETADATA_H
#define AVTMESHMETADATA_H
#include <dbatts_exports.h>
#include <string>
#include <avtTypes.h>
#include <AttributeSubject.h>

#include <NameschemeAttributes.h>

// ****************************************************************************
// Class: avtMeshMetaData
//
// Purpose:
//    Contains mesh metadata attributes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DBATTS_API avtMeshMetaData : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    avtMeshMetaData();
    avtMeshMetaData(const avtMeshMetaData &obj);
protected:
    // These constructors are for objects derived from this class
    avtMeshMetaData(private_tmfs_t tmfs);
    avtMeshMetaData(const avtMeshMetaData &obj, private_tmfs_t tmfs);
public:
    virtual ~avtMeshMetaData();

    virtual avtMeshMetaData& operator = (const avtMeshMetaData &obj);
    virtual bool operator == (const avtMeshMetaData &obj) const;
    virtual bool operator != (const avtMeshMetaData &obj) const;
private:
    void Init();
    void Copy(const avtMeshMetaData &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    avtMeshMetaData(const int *, const double *, std::string, int, int, int, int, int, int, avtMeshType);
    avtMeshMetaData(std::string, int, int, int, int, int, int, avtMeshType);
    void SetExtents(const double *);
    void UnsetExtents();
    void SetBounds(const int *);
    void UnsetBounds();
    void SetNumberCells(const int);
    void UnsetNumberCells();
    void Print(ostream &, int = 0) const;
    void SetAMRInfo(const std::string &levelName, const std::string &patchName, int origin,const std::vector<int> &patchesPerLevel);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_name = 0,
        ID_originalName,
        ID_validVariable,
        ID_meshType,
        ID_meshCoordType,
        ID_cellOrigin,
        ID_spatialDimension,
        ID_hasLogicalBounds,
        ID_logicalBounds,
        ID_hasNumberCells,
        ID_numberCells,
        ID_topologicalDimension,
        ID_xUnits,
        ID_yUnits,
        ID_zUnits,
        ID_xLabel,
        ID_yLabel,
        ID_zLabel,
        ID_hasSpatialExtents,
        ID_minSpatialExtents,
        ID_maxSpatialExtents,
        ID_numBlocks,
        ID_blockOrigin,
        ID_blockPieceName,
        ID_blockTitle,
        ID_blockNames,
        ID_blockNameScheme,
        ID_numGroups,
        ID_groupOrigin,
        ID_groupPieceName,
        ID_groupTitle,
        ID_groupNames,
        ID_groupIds,
        ID_groupIdsBasedOnRange,
        ID_disjointElements,
        ID_containsGhostZones,
        ID_containsOriginalCells,
        ID_containsOriginalNodes,
        ID_containsGlobalNodeIds,
        ID_containsGlobalZoneIds,
        ID_loadBalanceScheme,
        ID_nodesAreCritical,
        ID_unitCellVectors,
        ID_unitCellOrigin,
        ID_rectilinearGridHasTransform,
        ID_rectilinearGridTransform,
        ID_nodeOrigin,
        ID_containsExteriorBoundaryGhosts,
        ID_hideFromGUI,
        ID_LODs,
        ID_presentGhostZoneTypes,
        ID_zonesWereSplit,
        ID__LAST
    };

public:
    std::string          name;
    std::string          originalName;
    bool                 validVariable;
    avtMeshType          meshType;
    avtMeshCoordType     meshCoordType;
    int                  cellOrigin;
    int                  spatialDimension;
    bool                 hasLogicalBounds;
    int                  logicalBounds[3];
    bool                 hasNumberCells;
    int                  numberCells;
    int                  topologicalDimension;
    std::string          xUnits;
    std::string          yUnits;
    std::string          zUnits;
    std::string          xLabel;
    std::string          yLabel;
    std::string          zLabel;
    bool                 hasSpatialExtents;
    double               minSpatialExtents[3];
    double               maxSpatialExtents[3];
    int                  numBlocks;
    int                  blockOrigin;
    std::string          blockPieceName;
    std::string          blockTitle;
    stringVector         blockNames;
    NameschemeAttributes blockNameScheme;
    int                  numGroups;
    int                  groupOrigin;
    std::string          groupPieceName;
    std::string          groupTitle;
    stringVector         groupNames;
    intVector            groupIds;
    intVector            groupIdsBasedOnRange;
    bool                 disjointElements;
    avtGhostType         containsGhostZones;
    bool                 containsOriginalCells;
    bool                 containsOriginalNodes;
    bool                 containsGlobalNodeIds;
    bool                 containsGlobalZoneIds;
    LoadBalanceScheme    loadBalanceScheme;
    bool                 nodesAreCritical;
    float                unitCellVectors[9];
    float                unitCellOrigin[3];
    bool                 rectilinearGridHasTransform;
    double               rectilinearGridTransform[16];
    int                  nodeOrigin;
    bool                 containsExteriorBoundaryGhosts;
    bool                 hideFromGUI;
    int                  LODs;
    int                  presentGhostZoneTypes;
    bool                 zonesWereSplit;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AVTMESHMETADATA_TMFS "ssbiiiibIbiissssssbDDiisss*aiisss*i*i*bibbbbibFFbDibbiib"

#endif
