###############################################################################
# OpenVAS Vulnerability Test
# $Id: novell_edirectory_detect.nasl 7516 2010-05-04 08:24:56Z chandra $
#
# Novell eDirectory Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running Novell eDirectory server.

Risk factor : None";

if (description)
{
 script_id(100339);
 script_version ("1.0-$Revision: 7516 $");
 script_tag(name:"risk_factor", value:"None");

 script_name("Novell eDirectory Detection");
 script_description(desc);
 script_summary("Checks for the presence of Novell eDirectory");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("ldap_detect.nasl");
 script_require_ports("Services/ldap", 389);
 exit(0);
}

include("misc_func.inc");
include("dump.inc");
include("global_settings.inc");

port = get_kb_item("Services/ldap");
if(!port)exit(0);
if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);

req =
raw_string(0x30,0x25,0x02,0x01,0x01,0x63,0x20,0x04,0x00,0x0a,0x01,0x00,0x0a,0x01,0x00,0x02,
	   0x01,0x00,0x02,0x01,0x00,0x01,0x01,0x00,0x87,0x0b,0x6f,0x62,0x6a,0x65,0x63,0x74,
	   0x43,0x6c,0x61,0x73,0x73,0x30,0x00);

send(socket:soc, data:req);
data = recv(socket:soc, length:5000);

if( data == NULL ) exit(0);
close(soc);

len = strlen (data);

if(len <32)exit(0);

linenumber = len / 16;

for (i=0;i<=linenumber;i++) {
  for (j=0;j<16;j++) {
    if ((i*16+j)< len) {
      if(ord(data[i*16+j]) == "48" && ord(data[i*16+j+2]) == '4') {
        str += "#";
      } else {  
        c = data[i*16+j];
        if (isprint (c:c)) {
           str += c;
        }
       }
    }
  }
}

  if("eDirectory" >< str ) {
    version = eregmatch(string:str, pattern:"LDAP Agent for Novell eDirectory ([0-9.]+ ([^#]+)?)");
    if(!isnull(version[1])) {
      set_kb_item(name:string("ldap/",port,"/eDirectory"), value:version[1]);
      
      info = string("None\n\nNovell eDirectory Version '");
      info += string(version[1]);
      info += string("' was detected on the remote host\n");

      desc = ereg_replace(
          string:desc,
          pattern:"None$",
          replace:info
      );
    }
    if(report_verbosity > 0) {
      security_note(port:port,data:desc);
      exit(0);
    }
   }

exit(0);

