###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_winamp_gen_msn_bof_vuln.nasl 776 2009-03-10 15:21:38Z mar $
#
# Winamp gen_msn.dll Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800531);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0833");
  script_bugtraq_id(33159);
  script_name("Winamp gen_msn.dll Buffer Overflow Vulnerability");
  desc = "

  Overview: This host has Winamp Player with gen_msn Plugin installed and
  is prone to buffer overflow vulnerability.

  Vulnerability Insight:
  Boundary error exists in the player while processing overly long Winamp
  playlist entries in gen_msn.dll

  Impact:
  Attackers may leverage this issue by executing arbitrary code in the context
  of an affected application via specially crafted .pls files, and can cause
  buffer ovreflow.

  Impact Level: Application

  Affected Software/OS:
  Winamp version 5.541 and prior on Windows.

  Fix: Upgrade to Winamp version 5.572 or later
  For updates refer, http://www.winamp.com/plugins

  References:
  http://secunia.com/advisories/33425
  http://www.milw0rm.com/exploits/7696

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Size of Winamp's gen_msn.dll File");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_winamp_detect.nasl");
  script_require_keys("Winamp/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

winampVer = get_kb_item("Winamp/Version");
if(!winampVer){
  exit(0);
}

# Check for version 5.541 (5.5.4.2165) and prior
if(version_is_less_equal(version:winampVer, test_version:"5.5.4.2165"))
{
  winampPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows" +
                                   "\CurrentVersion\App Paths\winamp.exe",
                               item:"Path");
  if(!winampPath){
    exit(0);
  }

  winampPath =  winampPath + "\Plugins\gen_msn.dll";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:winampPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:winampPath);
  dllSize = get_file_size(share:share, file:file);

  if(dllSize != NULL && dllSize <= 45056){
    security_hole(0);
  }
}
