###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for openssh vulnerability USN-612-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840271);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "612-2");
  script_cve_id("CVE-2008-0166");
  script_name( "Ubuntu Update for openssh vulnerability USN-612-2");
  desc = "

  Vulnerability Insight:

  1. Install the security updates
  
  Ubuntu 7.04:
  openssh-client                  1:4.3p2-8ubuntu1.3
  openssh-server                  1:4.3p2-8ubuntu1.3
  
  Ubuntu 7.10:
  openssh-client                  1:4.6p1-5ubuntu0.3
  openssh-server                  1:4.6p1-5ubuntu0.3
  
  Ubuntu 8.04 LTS:
  openssh-client                  1:4.7p1-8ubuntu1.1
  openssh-server                  1:4.7p1-8ubuntu1.1
  
  Once the update is applied, weak user keys will be automatically
  rejected where possible (though they cannot be detected in all
  cases). If you are using such keys for user authentication,
  they will immediately stop working and will need to be replaced
  (see step 3).
  
  OpenSSH host keys can be automatically regenerated when the
  OpenSSH security update is applied. The update will prompt for
  confirmation before taking this step.
  
  2. Update OpenSSH known_hosts files
  
  The regeneration of host keys will cause a warning to be displayed
  when connecting to the system using SSH until the host key is
  updated in the known_hosts file. The warning will look like this:
  
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @    WARNING: REMOTE HOST IDENTIFICATION HAS CHANGED!     @
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  IT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY!
  Someone could be eavesdropping on you right now (man-in-the-middle
  attack)! It is also possible that the RSA host key has just been
  changed.
  
  In this case, the host key has simply been changed, and you
  should update the relevant known_hosts file as indicated in the
  error message.
  
  3. Check all OpenSSH user keys
  
  The safest course of action is to regenerate all OpenSSH user
  keys, except where it can be established to a high degree of
  certainty that the key was generated on an unaffected system.
  
  Check whether your key is affected by running the ssh-vulnkey
  tool, included in the security update. By default, ssh-vulnkey
  will check the standard location for user keys (~/.ssh/id_rsa,
  ~/.ssh/id_dsa and ~/.ssh/identity), your authorized_keys file
  (~/.ssh/authorized_keys and ~/.ssh/authorized_keys2), and the
  system's host keys (/etc/ssh/ssh_host_dsa_key and
  /etc/ssh/ssh_host_rsa_key).
  
  To check all your own keys, assuming they are in the standard
  locations (~/.ssh/id_rsa, ~/.ssh/id_dsa, or ~/.ssh/identity):
  
  $ ssh-vulnkey
  
  To check all keys on your system:
  
  $ sudo ssh-vulnkey -a
  
  To check a key in a non-standard location:
  
  $ ssh-vulnkey /path/to/key
  
  If ssh-vul ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  openssh vulnerability on Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-May/000706.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openssh vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"openssh-client", ver:"4.3p2-8ubuntu1.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssh-server", ver:"4.3p2-8ubuntu1.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-askpass-gnome", ver:"4.3p2-8ubuntu1.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh", ver:"4.3p2-8ubuntu1.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-krb5", ver:"4.3p2-8ubuntu1.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"openssh-client", ver:"4.7p1-8ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssh-server", ver:"4.7p1-8ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-askpass-gnome", ver:"4.7p1-8ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh", ver:"4.7p1-8ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-krb5", ver:"4.7p1-8ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"openssh-client", ver:"4.6p1-5ubuntu0.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssh-server", ver:"4.6p1-5ubuntu0.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-askpass-gnome", ver:"4.6p1-5ubuntu0.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh", ver:"4.6p1-5ubuntu0.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-krb5", ver:"4.6p1-5ubuntu0.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}