###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for postgresql FEDORA-2008-0478
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860326);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.2");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-0478");
  script_cve_id("CVE-2007-4769", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-6600", "CVE-2007-6601");
  script_name( "Fedora Update for postgresql FEDORA-2008-0478");
  desc = "

  Vulnerability Insight:
  PostgreSQL is an advanced Object-Relational database management system
  (DBMS) that supports almost all SQL constructs (including
  transactions, subselects and user-defined types and functions). The
  postgresql package includes the client programs and libraries that
  you'll need to access a PostgreSQL DBMS server.  These PostgreSQL
  client programs are programs that directly manipulate the internal
  structure of PostgreSQL databases on a PostgreSQL server. These client
  programs can be located on the same machine with the PostgreSQL
  server, or may be on a remote machine which accesses a PostgreSQL
  server over a network connection. This package contains the docs
  in HTML for the whole package, as well as command-line utilities for
  managing PostgreSQL databases on a PostgreSQL server.
  
  If you want to manipulate a PostgreSQL database on a remote PostgreSQL
  server, you need this package. You also need to install this package
  if you're installing the postgresql-server package.


  Affected Software/OS:
  postgresql on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-January/msg00397.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of postgresql");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-python", rpm:"postgresql-python~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-tcl", rpm:"postgresql-tcl~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-debuginfo", rpm:"postgresql-debuginfo~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-debuginfo", rpm:"postgresql-debuginfo~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-python", rpm:"postgresql-python~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-tcl", rpm:"postgresql-tcl~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.2.6~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}