# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8119 (bind)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64541);
 script_cve_id("CVE-2009-0696");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 11 FEDORA-2009-8119 (bind)");

 desc = "The remote host is missing an update to bind
announced via advisory FEDORA-2009-8119.

BIND (Berkeley Internet Name Domain) is an implementation of the DNS
(Domain Name System) protocols. BIND includes a DNS server (named),
which resolves host names to IP addresses; a resolver library
(routines for applications to use when interfacing with DNS); and
tools for verifying that the DNS server is operating properly.

Update Information:

Update to the latest release which fixes important security issue.
ChangeLog:

* Wed Jul 29 2009 Adam Tkac  32:9.6.1-4.P1
- 9.6.1-P1 release (CVE-2009-0696)
- fix postun trigger (#513016, hopefully)
* Mon Jul 13 2009 Adam Tkac  32:9.6.1-3
- fix broken symlinks in bind-libs (#509635)
- fix typos in /etc/sysconfig/named (#509650)
- add DEBUG option to /etc/sysconfig/named (#510283)

References:

[ 1 ] Bug #514292 - CVE-2009-0696 bind: DoS (assertion failure) via nsupdate packets
https://bugzilla.redhat.com/show_bug.cgi?id=514292

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update bind' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8119

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8119 (bind)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"bind", rpm:"bind~9.6.1~4.P1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chroot", rpm:"bind-chroot~9.6.1~4.P1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.6.1~4.P1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.6.1~4.P1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-sdb", rpm:"bind-sdb~9.6.1~4.P1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.6.1~4.P1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.6.1~4.P1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
