# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10639 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66133);
 script_cve_id("CVE-2009-3612", "CVE-2009-2909", "CVE-2009-2908", "CVE-2009-2903", "CVE-2009-3290", "CVE-2009-2847", "CVE-2009-2910");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-10639 (kernel)");

 desc = "The remote host is missing an update to kernel
announced via advisory FEDORA-2009-10639.

Update to kernel 2.6.30.9. Upstream change logs:
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.30.9
Also fixes:
- Kernel stack randomization bug
- NULL dereference in r128 driver
- ftrace memory corruption on module unload
- boot hanging on some systems
- some latency problems caused by scheduler bugs

References:

[ 1 ] Bug #524124 - CVE-2009-3290 kernel: KVM: x86: Disallow hypercalls for guest callers in rings > 0
https://bugzilla.redhat.com/show_bug.cgi?id=524124
[ 2 ] Bug #528868 - CVE-2009-3612 kernel: tcf_fill_node() infoleak due to typo in 9ef1d4c7
https://bugzilla.redhat.com/show_bug.cgi?id=528868
[ 3 ] Bug #522331 - CVE-2009-2903 kernel: appletalk: denial of service when handling IP tunnelled over DDP datagrams
https://bugzilla.redhat.com/show_bug.cgi?id=522331
[ 4 ] Bug #527534 - CVE-2009-2908 kernel ecryptfs NULL pointer dereference
https://bugzilla.redhat.com/show_bug.cgi?id=527534
[ 5 ] Bug #528887 - CVE-2009-2909 kernel: ax25 stack overflow
https://bugzilla.redhat.com/show_bug.cgi?id=528887
[ 6 ] Bug #526788 - CVE-2009-2910 kernel: x86_64 32 bit process register leak
https://bugzilla.redhat.com/show_bug.cgi?id=526788

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10639

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-10639 (kernel)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~i586~2.6.30.9", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~i686~2.6.30.9", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~ppc~2.6.30.9", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~ppc64~2.6.30.9", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~x86_64~2.6.30.9", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.30.9~90.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
