# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 912-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55942);
 script_bugtraq_id(15649);
 script_cve_id("CVE-2005-3694");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 912-1 (centericq)";
 script_name(name);

 desc = "The remote host is missing an update to centericq
announced via advisory DSA 912-1.

Wernfried Haas discovered that centericq, a text-mode multi-protocol
instant messenger client, can crash when it receives certain zero
length packets and is directly connected to the Internet.

For the old stable distribution (woody) this problem has been fixed in
version 4.5.1-1.1woody1.

For the stable distribution (sarge) this problem has been fixed in
version 4.20.0-1sarge3.

For the unstable distribution (sid) this problem has been fixed in
version 4.21.0-4.

We recommend that you upgrade your centericq package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20912-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 912-1 (centericq)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"centericq", ver:"4.5.1-1.1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"centericq", ver:"4.20.0-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"centericq-common", ver:"4.20.0-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"centericq-fribidi", ver:"4.20.0-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"centericq-utf8", ver:"4.20.0-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
