# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 893-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55874);
 script_cve_id("CVE-2005-3325");
 script_bugtraq_id(15199);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 893-1 (acidlab)";
 script_name(name);

 desc = "The remote host is missing an update to acidlab
announced via advisory DSA 893-1.

Remco Verhoef has discovered a vulnerability in acidlab, Analysis
Console for Intrusion Databases, and in acidbase, Basic Analysis and
Security Engine, which can be exploited by malicious users to conduct
SQL injection attacks.

The maintainers of Analysis Console for Intrusion Databases (ACID) in Debian,
of which BASE is a fork off, after a security audit of both BASE and ACID
have determined that the flaw found not only affected the base_qry_main.php (in
BASE) or acid_qry_main.php (in ACID) component but was also found in other
elements of the consoles due to improper parameter validation and filtering.

All the SQL injection bugs and Cross Site Scripting bugs found have been
fixed in the Debian package, closing all the different attack vendors detected.

For the old stable distribution (woody) this problem has been fixed in
version 0.9.6b20-2.1.

For the stable distribution (sarge) this problem has been fixed in
version 0.9.6b20-10.1.

For the unstable distribution (sid) this problem has been fixed in
version 0.9.6b20-13 and in version 1.2.1-1 of acidbase.

We recommend that you upgrade your acidlab and acidbase package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20893-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 893-1 (acidlab)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"acidlab", ver:"0.9.6b20-2.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"acidlab-doc", ver:"0.9.6b20-10.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"acidlab-mysql", ver:"0.9.6b20-10.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"acidlab-pgsql", ver:"0.9.6b20-10.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"acidlab", ver:"0.9.6b20-10.1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
