# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 573-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53265);
 script_cve_id("CVE-2004-0888");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 573-1 (cupsys)";
 script_name(name);

 desc = "The remote host is missing an update to cupsys
announced via advisory DSA 573-1.

Chris Evans discovered several integer overflows in xpdf, that are
also present in CUPS, the Common UNIX Printing System, which can be
exploited remotely by a specially crafted PDF document.

For the stable distribution (woody) these problems have been fixed in
version 1.1.14-5woody10.

For the unstable distribution (sid) these problems have been fixed in
version 1.1.20final+rc1-10.

We recommend that you upgrade your CUPS packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20573-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 573-1 (cupsys)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cupsys", ver:"1.1.14-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.1.14-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.1.14-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-pstoraster", ver:"1.1.14-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2", ver:"1.1.14-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.1.14-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
