# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1597-1 (mt-daapd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61172);
 script_cve_id("CVE-2007-5824", "CVE-2007-5825", "CVE-2008-1771");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1597-1 (mt-daapd)";
 script_name(name);

 desc = "The remote host is missing an update to mt-daapd
announced via advisory DSA 1597-1.

Three vulnerabilities have been discovered in the mt-daapd DAAP audio
server (also known as the Firefly Media Server).  The Common
Vulnerabilities and Exposures project identifies the following three
problems:

CVE-2007-5824

Insufficient validation and bounds checking of the Authorization:
HTTP header enables a heap buffer overflow, potentially enabling
the execution of arbitrary code.

CVE-2007-5825

Format string vulnerabilities in debug logging within the
authentication of XML-RPC requests could enable the execution of
arbitrary code.

CVE-2008-1771

An integer overflow weakness in the handling of HTTP POST
variables could allow a heap buffer overflow and potentially
arbitrary code execution.

For the stable distribution (etch), these problems have been fixed in
version 0.2.4+r1376-1.1+etch1.

For the unstable distribution (sid), these problems have been fixed in
version 0.9~r1696-1.3.

We recommend that you upgrade your mt-daapd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201597-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1597-1 (mt-daapd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mt-daapd", ver:"0.2.4+r1376-1.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
