# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 073-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53823);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 073-1 (imp)";
 script_name(name);

 desc = "The remote host is missing an update to imp
announced via advisory DSA 073-1.

The Horde team released version 2.2.6 of IMP (a web based IMAP mail
program) which fixes three security problems. Their release announcement
describes them as follows:

1. A PHPLIB vulnerability allowed an attacker to provide a value for the
array element $_PHPLIB[libdir], and thus to get scripts from another
server to load and execute.  This vulnerability is remotely
exploitable.  (Horde 1.2.x ships with its own customized version of
PHPLIB, which has now been patched to prevent this problem.)

2. By using tricky encodings of 'javascript:' an attacker can cause
malicious JavaScript code to execute in the browser of a user reading
email sent by attacker.  (IMP 2.2.x already filters many such
patterns; several new ones that were slipping past the filters are
now blocked.)

3. A hostile user that can create a publicly-readable file named
'prefs.lang' somewhere on the Apache/PHP server can cause that file
to be executed as PHP code.  The IMP configuration files could thus
be read, the Horde database password used to read and alter the
database used to store contacts and preferences, etc.  We do not
believe this is remotely exploitable directly through Apache/PHP/IMP;
however, shell access to the server or other means (e.g., FTP) could
be used to create this file.

This has been fixed in version 2:2.2.6-0.potato.1 . Please note you
will also need to upgrade the horde package to the same version.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20073-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 073-1 (imp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"horde", ver:"1.2.6-0.potato.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imp", ver:"2.2.6-0.potato.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
